/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.properties;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.security.SafeStorage;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSettings.class);
    private static final char[] DATABASE_KEY = "KLyt28r3xz".toCharArray();
    private static char @Nullable [] databasePassword = null;
    public static final String PASSWORD_PROPERTY = "EncryptedPassword";

    private DatabaseSettings() {
    }

    public static @Nullable String get(String name) {
        return Settings.get(SettingsFile.DATABASE, name);
    }

    public static String getString(String name, String def) {
        return Settings.getString(SettingsFile.DATABASE, name, def);
    }

    public static @Nullable String getPassword() {
        if (databasePassword != null) {
            return String.valueOf(databasePassword);
        }
        return null;
    }

    public static void loadPassword() {
        try {
            String encrypted = Settings.get(SettingsFile.DATABASE, PASSWORD_PROPERTY);
            if (encrypted != null) {
                databasePassword = SafeStorage.decrypt(encrypted, DATABASE_KEY).toCharArray();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to decrypt database password: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public static void setPassword(String password) {
        databasePassword = password.toCharArray();
        String encrypted = SafeStorage.encrypt(password, DATABASE_KEY);
        Settings.set(SettingsFile.DATABASE, PASSWORD_PROPERTY, encrypted);
    }
}

