/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.oauth;

import com.pageseeder.common.util.BinaryFormat;
import com.pageseeder.common.util.Hex;
import com.pageseeder.common.util.Strings;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.jdt.annotation.Nullable;

public final class Passwords {
    private static final int ITERATIONS = 1024;
    private static final int HASH_LENGTH_BYTES = 20;
    private static final int SALT_LENGTH_BYTES = 12;
    private static final int HASH_SALT_STORAGE_LENGTH = 64;
    private static final SecureRandom RANDOM = new SecureRandom();

    private Passwords() {
    }

    public static boolean match(char[] password, String hashAndSalt) {
        String hs = Passwords.sanitize(hashAndSalt);
        int separator = hs.length() - 24;
        String hash = hs.substring(0, separator);
        String salt = hs.substring(separator);
        byte[] saltBytes = Hex.decode(salt);
        byte[] hashBytes = Passwords.hash(password, saltBytes);
        String check = Hex.encode(hashBytes);
        return hash.equalsIgnoreCase(check);
    }

    public static String hash(char[] password) {
        if (password.length == 0) {
            throw new IllegalArgumentException("Unable to hash empty passwords");
        }
        byte[] salt = new byte[12];
        RANDOM.nextBytes(salt);
        byte[] hash = Passwords.hash(password, salt);
        return Hex.encode(hash) + Hex.encode(salt);
    }

    static boolean isValidHashAndSalt(@Nullable String hashAndSalt) {
        return hashAndSalt != null && hashAndSalt.length() == 64 && Strings.isHex(hashAndSalt);
    }

    public static String randomBytes(int length, BinaryFormat format) {
        byte[] data = new byte[length];
        RANDOM.nextBytes(data);
        return format.encode(data);
    }

    public static String random(int length, char[] range) {
        Passwords.checkRange(range);
        StringBuilder password = new StringBuilder(length);
        byte[] data = new byte[length];
        RANDOM.nextBytes(data);
        for (byte a : data) {
            password.append(Passwords.toChar(a, range));
        }
        return password.toString();
    }

    private static byte[] hash(char[] password, byte[] salt) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, 1024, 160);
            SecretKeyFactory key = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = key.generateSecret(spec).getEncoded();
            if (hash == null) {
                throw new GeneralSecurityException("Key does not support encoding");
            }
            return hash;
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("Unable to hash password", ex);
        }
    }

    private static String sanitize(String hashAndSalt) {
        if (Passwords.isValidHashAndSalt(hashAndSalt)) {
            return hashAndSalt;
        }
        return Passwords.randomBytes(32, BinaryFormat.HEX);
    }

    private static void checkRange(char @Nullable [] range) {
        if (range == null) {
            throw new NullPointerException("Character range is null");
        }
        if (range.length < 2) {
            throw new IllegalArgumentException("Character range is less than 2 characters");
        }
    }

    private static char toChar(byte b, char[] range) {
        return range[(b & 0x7F) % range.length];
    }
}

