/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.net;

import com.pageseeder.common.util.Preconditions;
import org.eclipse.jdt.annotation.Nullable;

public final class URLs {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;

    private URLs() {
    }

    public static String asString(String scheme, String host, int port, @Nullable String path, @Nullable String query, @Nullable String fragment) {
        Preconditions.checkNotEmpty(scheme, "Scheme is empty");
        Preconditions.checkNotEmpty(host, "Host is empty");
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(host);
        if (!URLs.isDefaultPort(scheme, port)) {
            url.append(':').append(port);
        }
        url.append(path != null ? path : Character.valueOf('/'));
        if (query != null) {
            url.append('?').append(query);
        }
        if (fragment != null) {
            url.append('#').append(fragment);
        }
        return url.toString();
    }

    public static String asString(String scheme, String host, int port, String path, String query) {
        return URLs.asString(scheme, host, port, path, query, null);
    }

    public static String asString(String scheme, String host, int port, @Nullable String path) {
        return URLs.asString(scheme, host, port, path, null, null);
    }

    public static boolean isDefaultPort(String scheme, int port) {
        if (port == 80 && HTTP_SCHEME.equals(scheme)) {
            return true;
        }
        return port == 443 && HTTPS_SCHEME.equals(scheme);
    }
}

