/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Locations;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public final class TemplateHistory {
    public static final String HISTORY_FOLDER = ".history";
    private static final String EXTENSION_PREFIX = ".r";
    private final TemplateFiles resources;

    public TemplateHistory(Template template, File webapp) {
        this.resources = new TemplateFiles(template, webapp);
    }

    public TemplateHistory(TemplateFiles resources) {
        this.resources = Objects.requireNonNull(resources);
    }

    public boolean backup(TemplateZone zone, String location) throws IOException {
        File file = this.resources.get(zone, location);
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        return this.backup(file, zone, location);
    }

    public boolean backup(String location) throws IOException {
        File file = this.resources.get(location);
        TemplateZone zone = this.resources.getZone(location);
        if (zone == null || file == null) {
            return false;
        }
        String rel = location.substring(zone.folder(this.resources.template()).length());
        return this.backup(file, zone, rel);
    }

    public void restore(TemplateZone zone, String location, int revision) throws IOException {
        File file = this.resources.get(zone, location);
        if (file == null) {
            throw new IllegalArgumentException("Unable to get file at this location");
        }
        String name = Locations.getFilename(location);
        File folder = this.getHistoryFolder(zone, location);
        File backup = new File(folder, name + EXTENSION_PREFIX + revision);
        java.nio.file.Files.copy(backup.toPath(), file.toPath(), new CopyOption[0]);
    }

    public void clear(TemplateZone zone) throws IOException {
        File history = this.resources.get(zone, HISTORY_FOLDER);
        if (history != null) {
            Files.deleteFolder(history);
        }
    }

    public int getLastRevision(TemplateZone zone, String location) {
        File folder = this.getHistoryFolder(zone, location);
        String name = Locations.getFilename(location);
        return Revisions.last(folder, name);
    }

    public List<File> getHistory(String location) {
        TemplateZone zone = this.resources.getZone(location);
        if (zone == null) {
            return Collections.emptyList();
        }
        String rel = location.substring(zone.folder(this.resources.template()).length());
        return this.getHistory(zone, rel);
    }

    public List<File> getHistory(TemplateZone zone, String location) {
        File folder = this.getHistoryFolder(zone, location);
        String name = Locations.getFilename(location);
        return Revisions.files(folder, name);
    }

    private boolean backup(File file, TemplateZone zone, String location) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        String name = Locations.getFilename(location);
        File folder = this.getHistoryFolder(zone, location);
        int r = Revisions.last(folder, name) + 1;
        File next = new File(folder, name + EXTENSION_PREFIX + r);
        Files.copy(file, next, new CopyOption[0]);
        return true;
    }

    private File getHistoryFolder(TemplateZone zone, String location) {
        File history = this.resources.get(zone, HISTORY_FOLDER);
        if (history == null) {
            throw new IllegalArgumentException("Unable to get history folder at this location");
        }
        String path = Locations.getFolder(location);
        return path.length() > 0 ? new File(history, path) : history;
    }

    private static class Revisions
    implements FileFilter {
        private static final Comparator<File> REVISION_COMPARATOR = (f1, f2) -> {
            int r1 = Integer.parseInt(f1.getName().substring(f1.getName().lastIndexOf(TemplateHistory.EXTENSION_PREFIX) + 2));
            int r2 = Integer.parseInt(f2.getName().substring(f2.getName().lastIndexOf(TemplateHistory.EXTENSION_PREFIX) + 2));
            return r1 - r2;
        };
        private final String name;
        private int last = -1;

        public Revisions(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            boolean isRevision = false;
            if (filename.startsWith(this.name + TemplateHistory.EXTENSION_PREFIX)) {
                String r = filename.substring(this.name.length() + 2);
                try {
                    int i = Integer.parseInt(r);
                    if (i > this.last) {
                        this.last = i;
                    }
                    isRevision = true;
                }
                catch (NumberFormatException ex) {
                    isRevision = false;
                }
            }
            return isRevision;
        }

        public int last() {
            return this.last;
        }

        public static int last(File folder, String name) {
            Revisions revisions = new Revisions(name);
            folder.listFiles(revisions);
            return revisions.last();
        }

        public static List<File> files(File folder, String name) {
            File[] revs;
            Revisions revisions = new Revisions(name);
            ArrayList<File> files = new ArrayList<File>();
            if (folder.exists() && (revs = folder.listFiles(revisions)) != null) {
                files.addAll(Arrays.asList(revs));
            }
            files.sort(REVISION_COMPARATOR);
            return files;
        }
    }
}

