/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files {
    private static final Logger LOGGER = LoggerFactory.getLogger(Files.class);
    static final FileFilter ALL_READABLE_AND_VISIBLE = file -> file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0;
    static final FileFilter FILES_READABLE_AND_VISIBLE = file -> file.isFile() && file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0;
    static final FileFilter FOLDERS_READABLE_AND_VISIBLE = file -> file.isDirectory() && file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0;

    private Files() {
    }

    public static void copy(File source, File target, CopyOption ... options) throws IOException {
        target.getParentFile().mkdirs();
        java.nio.file.Files.copy(source.toPath(), target.toPath(), options);
    }

    public static void copy(File source, OutputStream out) throws IOException {
        java.nio.file.Files.copy(source.toPath(), out);
    }

    public static void copy(InputStream source, File out) throws IOException {
        java.nio.file.Files.copy(source, out.toPath(), new CopyOption[0]);
    }

    public static void deleteFolder(File path) throws IOException {
        java.nio.file.Files.walkFileTree(path.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                java.nio.file.Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, @Nullable IOException e) {
                return this.handleException(e);
            }

            private FileVisitResult handleException(@Nullable IOException ex) {
                if (ex != null) {
                    LOGGER.error("Error deleting file: {}", (Object)ex.getMessage());
                }
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException e) throws IOException {
                if (e != null) {
                    return this.handleException(e);
                }
                java.nio.file.Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String path(File root, File file) throws IOException {
        String from = root.getCanonicalPath();
        String to = file.getCanonicalPath();
        if (to.startsWith(from)) {
            String path = to.substring(from.length()).replace("\\", "/");
            return path.startsWith("/") ? path.substring(1) : path;
        }
        throw new IllegalArgumentException("Cannot determine the path between the specified files.");
    }

    public static String safePath(File root, File file) {
        Path rootPath = root.toPath().toAbsolutePath().normalize();
        Path filePath = file.toPath().toAbsolutePath().normalize();
        if (filePath.startsWith(rootPath)) {
            return rootPath.relativize(filePath).toString().replace("\\", "/");
        }
        throw new IllegalArgumentException("Cannot determine the path between the specified files.");
    }

    public static boolean isDescendantOf(File root, File file) throws IOException {
        String from = root.getCanonicalPath();
        String to = file.getCanonicalPath();
        return to.startsWith(from + File.separator);
    }

    public static boolean isDescendantOfSafe(File root, String file) {
        Path from = root.toPath().toAbsolutePath().normalize();
        Path to = from.resolve(file).normalize();
        return to.startsWith(String.valueOf(from) + File.separator);
    }

    public static List<File> children(File dir) {
        @NonNull File @Nullable [] files = dir.listFiles(ALL_READABLE_AND_VISIBLE);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    public static List<File> childrenFiles(File dir) {
        @NonNull File @Nullable [] files = dir.listFiles(FILES_READABLE_AND_VISIBLE);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    public static List<File> childrenFolders(File dir) {
        @NonNull File @Nullable [] files = dir.listFiles(FOLDERS_READABLE_AND_VISIBLE);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    public static List<File> descendants(File dir, boolean filesOnly) {
        ArrayList<File> descendants = new ArrayList<File>();
        File[] files = dir.listFiles(ALL_READABLE_AND_VISIBLE);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!filesOnly) {
                        descendants.add(file);
                    }
                    descendants.addAll(Files.descendants(file, filesOnly));
                    continue;
                }
                descendants.add(file);
            }
        }
        return descendants;
    }

    public static int countChildrenFiles(File dir) {
        File[] files = dir.listFiles(FILES_READABLE_AND_VISIBLE);
        return files == null ? 0 : files.length;
    }

    public static int countChildren(File dir) {
        File[] files = dir.listFiles(ALL_READABLE_AND_VISIBLE);
        return files == null ? 0 : files.length;
    }

    public static int countDescendantsFiles(File dir) {
        int total = 0;
        File[] files = dir.listFiles(ALL_READABLE_AND_VISIBLE);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    total += Files.countDescendantsFiles(file);
                    continue;
                }
                ++total;
            }
        }
        return total;
    }

    public static int countDescendants(File dir) {
        int total = 0;
        File[] files = dir.listFiles(ALL_READABLE_AND_VISIBLE);
        if (files != null) {
            for (File file : files) {
                ++total;
                if (!file.isDirectory()) continue;
                total += Files.countDescendants(file);
            }
        }
        return total;
    }

    public static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }

    public static File safeDescendantFile(File base, String path) {
        Path basePath = base.toPath().toAbsolutePath().normalize();
        Path descendantPath = basePath.resolve(path).normalize();
        if (!descendantPath.startsWith(basePath)) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IllegalArgumentException("Path results in a file outside base folder");
        }
        return descendantPath.toFile();
    }
}

