/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public abstract class AutoGzipOutputStream
extends FilterOutputStream {
    public static final int DEFAULT_GZIP_THRESHOLD = 1024;
    private final int threshold;
    private OutputStream filter;
    private int count = 0;
    private boolean isCompressed;

    protected AutoGzipOutputStream(OutputStream out) {
        this(out, 1024);
    }

    protected AutoGzipOutputStream(OutputStream out, int threshold) {
        super(out);
        this.threshold = threshold;
        this.filter = threshold >= 0 ? new ByteArrayOutputStream(1024) : out;
    }

    @Override
    public void write(int b) throws IOException {
        int updateCount = this.count + 1;
        this.ensureCompression(updateCount);
        this.filter.write(b);
        this.count += updateCount;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Length must be greater than 0");
        }
        int updateCount = this.count + len;
        this.ensureCompression(updateCount);
        this.filter.write(b, off, len);
        this.count = updateCount;
    }

    private void ensureCompression(int length) throws IOException {
        if (!this.isCompressed && this.threshold >= 0 && length > this.threshold) {
            byte[] initial = ((ByteArrayOutputStream)this.filter).toByteArray();
            this.filter = new GZIPOutputStream(this.out);
            this.filter.write(initial);
            this.isCompressed = true;
            this.switchToGzip();
        }
    }

    public abstract void switchToGzip();

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int size() {
        return this.count;
    }

    @Override
    public void flush() {
    }

    public void finish() throws IOException {
        if (this.filter instanceof GZIPOutputStream) {
            ((GZIPOutputStream)this.filter).finish();
        } else if (this.filter instanceof ByteArrayOutputStream) {
            byte[] content = ((ByteArrayOutputStream)this.filter).toByteArray();
            this.out.write(content);
        }
    }

    @Override
    public void close() throws IOException {
        this.filter.close();
    }
}

