/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import com.pageseeder.common.http.HttpRedirect;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWebRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWebRequest.class);
    protected final HttpServletRequest req;
    protected final HttpServletResponse res;
    protected int status = 200;

    public HttpWebRequest(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
    }

    public final HttpServletRequest request() {
        return this.req;
    }

    public final HttpServletResponse response() {
        return this.res;
    }

    public final @Nullable String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public final @Nullable String getParameter(String name, boolean required) {
        String value = this.req.getParameter(name);
        if (required && (value == null || value.isEmpty())) {
            this.sendError(400, HttpWebRequest.toMissingMessage(name, value));
            return null;
        }
        return value;
    }

    public final String getParameter(String name, String def) {
        String value = this.req.getParameter(name);
        return value != null ? value : def;
    }

    public final @Nullable Long getLongParameter(String name, boolean required, @Nullable Long def) {
        String value = this.req.getParameter(name);
        if (value == null || value.isEmpty()) {
            if (required) {
                this.sendError(400, HttpWebRequest.toMissingMessage(name, value));
                return null;
            }
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            this.sendError(400, "Long parameter '" + name + "' is not a valid number");
            return def;
        }
    }

    public final boolean getBooleanParameter(String name, boolean def) {
        String value = this.req.getParameter(name);
        if (value == null || value.isEmpty()) {
            return def;
        }
        if (def) {
            return "false".equals(value) || "no".equals(value);
        }
        return "true".equals(value) || "yes".equals(value);
    }

    public final @Nullable Long getLongParameter(String name, boolean required) {
        return this.getLongParameter(name, required, null);
    }

    public void sendRedirect(String location) {
        String url = HttpRedirect.getRedirectURL(this.req, location);
        try {
            this.res.sendRedirect(url);
        }
        catch (IOException ex) {
            this.sendError(500, ex);
        }
    }

    public void sendError(int code, String message) {
        if (this.res.isCommitted()) {
            HttpWebRequest.alreadyCommitted(code, message);
            return;
        }
        this.status = code;
        try {
            this.res.sendError(code, message);
        }
        catch (IOException io) {
            HttpWebRequest.swallow(io);
        }
    }

    public void sendError(int code, Exception ex) {
        if (this.res.isCommitted()) {
            HttpWebRequest.alreadyCommitted(code, Objects.toString(ex.getMessage(), ex.getClass().getName()));
            return;
        }
        this.status = code;
        try {
            if (code == 500) {
                this.req.setAttribute("javax.servlet.error.exception", (Object)ex);
            } else {
                this.req.setAttribute("com.pageseeder.error.exception", (Object)ex);
            }
            this.res.sendError(code, ex.getMessage());
        }
        catch (IOException io) {
            HttpWebRequest.swallow(io);
        }
    }

    public final boolean hasError() {
        int start_http_error_code = 400;
        return this.status >= 400;
    }

    public final int getStatus() {
        return this.status;
    }

    private static String toMissingMessage(String name, @Nullable String value) {
        return "Parameter '" + name + "' is required; but value was " + (value != null ? "\"\" (empty string)" : "null");
    }

    protected static void swallow(IOException ex) {
        LOGGER.error("Swallowed IO exception while trying to send error", (Throwable)ex);
    }

    protected static void alreadyCommitted(int code, String message) {
        LOGGER.warn("Unable to send error {}:{} as response is already committed", (Object)code, (Object)message);
    }
}

