/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRedirect {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRedirect.class);

    private HttpRedirect() {
    }

    public static void sendRedirect(HttpServletRequest req, HttpServletResponse res, String location) throws IOException {
        String url = HttpRedirect.getRedirectURL(req, location);
        res.sendRedirect(url);
    }

    public static String getRedirectURL(HttpServletRequest req, String location) {
        if (location.startsWith("http")) {
            return location;
        }
        try {
            String baseURL = HttpRedirect.getBaseURLFromForwarded(req);
            if (baseURL == null) {
                baseURL = HttpRedirect.getBaseURLFromXForwarded(req);
            }
            if (baseURL == null) {
                baseURL = HttpRedirect.getBaseURLFromXScheme(req);
            }
            if (baseURL != null) {
                URI url = URI.create(baseURL);
                if (!location.startsWith("/")) {
                    url = url.resolve(req.getRequestURI());
                }
                return url.resolve(location).toString();
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Unable to create redirect URL from forwarded headers: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return location;
    }

    private static @Nullable String getBaseURLFromForwarded(HttpServletRequest req) {
        String forwarded = req.getHeader("Forwarded");
        if (forwarded == null || forwarded.isEmpty()) {
            return null;
        }
        String[] directives = forwarded.split(";");
        String host = null;
        String proto = null;
        for (String directive : directives) {
            if (directive.startsWith("host=")) {
                host = directive.substring(5);
                continue;
            }
            if (!directive.startsWith("proto=")) continue;
            proto = directive.substring(6);
        }
        LOGGER.debug("Forwarded proto={}, host={}", proto, host);
        return HttpRedirect.toBaseURL(req, proto, host);
    }

    private static @Nullable String getBaseURLFromXForwarded(HttpServletRequest req) {
        String proto = req.getHeader("X-Forwarded-Proto");
        String host = req.getHeader("X-Forwarded-Host");
        LOGGER.debug("X-Forwarded proto={}, host={}", (Object)proto, (Object)host);
        return HttpRedirect.toBaseURL(req, proto, host);
    }

    private static @Nullable String getBaseURLFromXScheme(HttpServletRequest req) {
        String proto = req.getHeader("X-Scheme");
        LOGGER.debug("X-Scheme={}", (Object)proto);
        return HttpRedirect.toBaseURL(req, proto, null);
    }

    private static @Nullable String toBaseURL(HttpServletRequest req, @Nullable String proto, @Nullable String host) {
        if (HttpRedirect.isValidProto(proto)) {
            return proto + "://" + (host != null ? host : req.getServerName());
        }
        if (host != null) {
            return req.getScheme() + "://" + host;
        }
        return null;
    }

    private static boolean isValidProto(@Nullable String proto) {
        return "https".equals(proto) || "http".equals(proto);
    }
}

