/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptBase;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextTemplate;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlFormat {
    private XmlFormat() {
    }

    public static void toXML(PromptTemplate template, XMLWriter xml) throws IOException {
        xml.openElement("prompt-template", true);
        XmlFormat.promptAttributes(template, xml);
        if (!template.getSystem().template().isEmpty()) {
            xml.openElement("system");
            xml.writeText(template.getSystem().template());
            xml.closeElement();
        }
        xml.openElement("user", true);
        for (ContentSpec spec : template.getUser()) {
            if (spec instanceof TextTemplate) {
                xml.openElement("text");
                xml.writeText(((TextTemplate)spec).template());
                xml.closeElement();
                continue;
            }
            xml.openElement("attachment");
            xml.attribute("ref", ((Attachment)spec).ref());
            xml.closeElement();
        }
        xml.closeElement();
        xml.closeElement();
    }

    public static void toXML(Prompt prompt, XMLWriter xml) throws IOException {
        xml.openElement("prompt", true);
        XmlFormat.promptAttributes(prompt, xml);
        if (!prompt.getSystem().isEmpty()) {
            xml.openElement("system");
            xml.writeText(prompt.getSystem());
            xml.closeElement();
        }
        xml.openElement("user", true);
        for (Content content : prompt.getUser()) {
            xml.openElement("content");
            xml.attribute("media-type", content.mediaType());
            if (content.isText()) {
                xml.writeText(content.getText());
            } else {
                xml.attribute("data", content.getText());
            }
            xml.closeElement();
        }
        xml.closeElement();
        xml.closeElement();
    }

    private static void promptAttributes(PromptBase prompt, XMLWriter xml) throws IOException {
        xml.attribute("id", prompt.getId());
        xml.attribute("type", prompt.getType());
        xml.attribute("owner", prompt.getOwner());
        xml.attribute("temperature", Double.toString(prompt.getTemperature()));
        xml.attribute("max-tokens", prompt.getMaxTokens());
        if (prompt.model != null) {
            xml.attribute("model", prompt.getModel());
        }
    }

    public static String toString(PromptTemplate template) {
        StringWriter writer = new StringWriter();
        XMLWriterImpl xml = new XMLWriterImpl((Writer)writer, true);
        try {
            XmlFormat.toXML(template, (XMLWriter)xml);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return writer.toString();
    }

    public static PromptTemplate parse(String template) throws ParseException, IOException {
        try (StringReader reader = new StringReader(template);){
            PromptTemplate promptTemplate = XmlFormat.parse(reader);
            return promptTemplate;
        }
    }

    public static PromptTemplate parse(File file) throws ParseException, IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            PromptTemplate promptTemplate = XmlFormat.parse(reader);
            return promptTemplate;
        }
    }

    public static PromptTemplate parse(Reader reader) throws ParseException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser saxParser = factory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(new InputSource(reader), (DefaultHandler)handler);
            return handler.getPromptDefinition();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public static class Handler
    extends DefaultHandler {
        private static final PromptTemplate EMPTY = new PromptTemplate();
        private PromptTemplate template = EMPTY;
        private final StringBuilder textBuffer = new StringBuilder();

        public PromptTemplate getPromptDefinition() {
            return this.template;
        }

        @Override
        public void startDocument() {
            this.template = new PromptTemplate();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.textBuffer.setLength(0);
            if ("prompt-template".equals(qName)) {
                String maxTokens;
                String temperature;
                String model;
                this.template.setId(attributes.getValue("id"));
                this.template.setType(attributes.getValue("type"));
                String owner = attributes.getValue("owner");
                if (owner != null) {
                    this.template.setOwner(owner);
                }
                if ((model = attributes.getValue("model")) != null) {
                    this.template.setModel(model);
                }
                if ((temperature = attributes.getValue("temperature")) != null) {
                    try {
                        this.template.setTemperature(Double.parseDouble(temperature));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SAXException("Invalid temperature value: " + temperature);
                    }
                }
                if ((maxTokens = attributes.getValue("max-tokens")) != null) {
                    try {
                        this.template.setMaxTokens(Integer.parseInt(maxTokens));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SAXException("Invalid max tokens value: " + temperature);
                    }
                }
            }
            if ("attachment".equals(qName)) {
                Attachment attachment = new Attachment(attributes.getValue("ref"));
                this.template.addUser(attachment);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.textBuffer.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("text".equals(qName)) {
                this.template.addUser(new TextTemplate(this.textBuffer.toString()));
            } else if ("system".equals(qName)) {
                this.template.setSystem(this.textBuffer.toString().trim());
            }
        }
    }
}

