/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Options;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptBase;
import net.pageseeder.ai.prompt.TextContent;
import net.pageseeder.ai.prompt.TextTemplate;

public class PromptTemplate
extends PromptBase {
    private TextTemplate system = TextTemplate.EMPTY;
    private List<ContentSpec> user = new ArrayList<ContentSpec>();

    public TextTemplate getSystem() {
        return this.system;
    }

    public List<ContentSpec> getUser() {
        return this.user;
    }

    public void setSystem(String template) {
        this.system = new TextTemplate(template);
    }

    public void resetUser() {
        this.user = new ArrayList<ContentSpec>();
    }

    public void setUser(String template) {
        this.user = new ArrayList<ContentSpec>();
        if (!template.isEmpty()) {
            this.user.add(new TextTemplate(template));
        }
    }

    public void addUser(ContentSpec contentSpec) {
        this.user.add(contentSpec);
    }

    public String toSystemPrompt(Map<String, String> parameters, Options options) {
        return this.system.toPrompt(parameters, options);
    }

    public List<Content> toUserPrompt(Map<String, String> parameters, Options options) {
        ArrayList<Content> contents = new ArrayList<Content>();
        for (ContentSpec contentSpec : this.user) {
            contents.addAll(contentSpec.getContents(parameters, options));
        }
        return PromptTemplate.normalize(contents);
    }

    public Prompt toPrompt(Map<String, String> parameters) {
        return this.toPrompt(parameters, Options.defaultOptions());
    }

    public Prompt toPrompt(Map<String, String> parameters, Options options) {
        Prompt prompt = new Prompt(this.id, this.type);
        prompt.setMaxTokens(this.maxTokens);
        prompt.setModel(this.model);
        prompt.setOwner(this.owner);
        prompt.setTemperature(this.temperature);
        prompt.setSystem(this.toSystemPrompt(parameters, options));
        prompt.setUser(this.toUserPrompt(parameters, options));
        return prompt;
    }

    public List<String> listAttachmentRefs() {
        return this.user.stream().filter(Attachment.class::isInstance).map(it -> ((Attachment)it).ref()).collect(Collectors.toList());
    }

    public List<String> listPlaceholders() {
        ArrayList<String> placeholders = new ArrayList<String>(this.system.placeholders());
        for (ContentSpec spec : this.user) {
            if (!(spec instanceof TextTemplate)) continue;
            placeholders.addAll(((TextTemplate)spec).placeholders());
        }
        return placeholders;
    }

    public static List<Content> normalize(List<Content> contents) {
        ArrayList<Content> normalized = new ArrayList<Content>();
        StringBuilder coalesce = new StringBuilder();
        for (Content content : contents) {
            if (content.isText()) {
                coalesce.append(content.getText());
                continue;
            }
            if (coalesce.length() > 0) {
                normalized.add(new TextContent(coalesce.toString()));
                coalesce.setLength(0);
            }
            normalized.add(content);
        }
        if (coalesce.length() > 0) {
            normalized.add(new TextContent(coalesce.toString()));
        }
        return normalized;
    }
}

