/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.DataContent;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptBase;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextContent;
import net.pageseeder.ai.prompt.TextTemplate;

public final class JsonFormat {
    private static final String ID_PROPERTY = "id";
    private static final String TYPE_PROPERTY = "type";
    private static final String TEMPERATURE_PROPERTY = "temperature";
    private static final String MAX_TOKENS_PROPERTY = "maxTokens";
    private static final String OWNER_PROPERTY = "owner";
    private static final String MODEL_PROPERTY = "model";
    private static final String SYSTEM_PROPERTY = "system";
    private static final String USER_PROPERTY = "user";
    private static final String MEDIA_TYPE_PROPERTY = "mediaType";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    private JsonFormat() {
    }

    public static void write(PromptTemplate template, Writer writer) throws IOException {
        try (JsonGenerator generator = MAPPER.getFactory().createGenerator(writer);){
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            JsonFormat.writeCommonFields(generator, template);
            if (!template.getSystem().template().isEmpty()) {
                generator.writeStringField(SYSTEM_PROPERTY, template.getSystem().template());
            }
            generator.writeArrayFieldStart(USER_PROPERTY);
            for (ContentSpec spec : template.getUser()) {
                if (spec instanceof TextTemplate) {
                    generator.writeStartObject();
                    generator.writeStringField(TYPE_PROPERTY, "text");
                    generator.writeStringField("text", ((TextTemplate)spec).template());
                    generator.writeEndObject();
                    continue;
                }
                if (!(spec instanceof Attachment)) continue;
                generator.writeStartObject();
                generator.writeStringField(TYPE_PROPERTY, "attachment");
                generator.writeStringField("ref", ((Attachment)spec).ref());
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static void write(Prompt prompt, Writer json) throws IOException {
        try (JsonGenerator generator = MAPPER.getFactory().createGenerator(json);){
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            JsonFormat.writeCommonFields(generator, prompt);
            if (!prompt.getSystem().isEmpty()) {
                generator.writeStringField(SYSTEM_PROPERTY, prompt.getSystem());
            }
            generator.writeArrayFieldStart(USER_PROPERTY);
            for (Content content : prompt.getUser()) {
                generator.writeStartObject();
                generator.writeStringField(MEDIA_TYPE_PROPERTY, content.mediaType());
                if (content.isText()) {
                    generator.writeStringField("text", content.getText());
                } else {
                    generator.writeStringField("data", content.getText());
                }
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static String toString(PromptTemplate template) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            JsonFormat.write(template, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        writer.close();
        return string;
    }

    public static String toString(Prompt prompt) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            JsonFormat.write(prompt, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        writer.close();
        return string;
    }

    public static PromptTemplate parseTemplate(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            PromptTemplate promptTemplate = JsonFormat.parseTemplate(reader);
            return promptTemplate;
        }
    }

    public static PromptTemplate parseTemplate(String json) throws IOException {
        try (StringReader reader = new StringReader(json);){
            PromptTemplate promptTemplate = JsonFormat.parseTemplate(reader);
            return promptTemplate;
        }
    }

    public static PromptTemplate parseTemplate(Reader reader) throws IOException {
        JsonNode root = MAPPER.readTree(reader);
        PromptTemplate template = new PromptTemplate();
        JsonFormat.loadCommonFields(root, template);
        if (root.has(SYSTEM_PROPERTY)) {
            template.setSystem(root.get(SYSTEM_PROPERTY).asText());
        }
        if (root.has(USER_PROPERTY) && root.get(USER_PROPERTY).isArray()) {
            ArrayNode userArray = (ArrayNode)root.get(USER_PROPERTY);
            for (JsonNode node : userArray) {
                if (!node.has(TYPE_PROPERTY)) continue;
                String type = node.get(TYPE_PROPERTY).asText();
                if (type.equals("text") && node.has("text")) {
                    template.addUser(new TextTemplate(node.get("text").asText()));
                    continue;
                }
                if (!type.equals("attachment") || !node.has("ref")) continue;
                template.addUser(new Attachment(node.get("ref").asText()));
            }
        }
        return template;
    }

    public static Prompt parsePrompt(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Prompt prompt = JsonFormat.parsePrompt(reader);
            return prompt;
        }
    }

    public static Prompt parsePrompt(String json) throws IOException {
        try (StringReader reader = new StringReader(json);){
            Prompt prompt = JsonFormat.parsePrompt(reader);
            return prompt;
        }
    }

    public static Prompt parsePrompt(Reader reader) throws IOException {
        JsonNode root = MAPPER.readTree(reader);
        Prompt prompt = new Prompt(root.get(ID_PROPERTY).asText(), root.get(TYPE_PROPERTY).asText());
        JsonFormat.loadCommonFields(root, prompt);
        if (root.has(SYSTEM_PROPERTY)) {
            prompt.setSystem(root.get(SYSTEM_PROPERTY).asText());
        }
        ArrayList<Content> userContents = new ArrayList<Content>();
        if (root.has(USER_PROPERTY) && root.get(USER_PROPERTY).isArray()) {
            ArrayNode userArray = (ArrayNode)root.get(USER_PROPERTY);
            for (JsonNode node : userArray) {
                if (!node.has(MEDIA_TYPE_PROPERTY)) continue;
                String mediaType = node.get(MEDIA_TYPE_PROPERTY).asText();
                if (node.has("text")) {
                    userContents.add(new TextContent(node.get("text").asText()));
                    continue;
                }
                if (!node.has("data")) continue;
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytes = decoder.decode(node.get("data").asText());
                userContents.add(new DataContent(mediaType, bytes));
            }
        }
        prompt.setUser(userContents);
        return prompt;
    }

    private static void writeCommonFields(JsonGenerator generator, PromptBase prompt) throws IOException {
        generator.writeStringField(ID_PROPERTY, prompt.getId());
        generator.writeStringField(TYPE_PROPERTY, prompt.getType());
        generator.writeNumberField(TEMPERATURE_PROPERTY, prompt.getTemperature());
        generator.writeNumberField(MAX_TOKENS_PROPERTY, prompt.getMaxTokens());
        generator.writeStringField(OWNER_PROPERTY, prompt.getOwner());
        if (prompt.model != null) {
            generator.writeStringField(MODEL_PROPERTY, prompt.getModel());
        }
    }

    private static void loadCommonFields(JsonNode root, PromptBase prompt) {
        prompt.setId(root.get(ID_PROPERTY).asText());
        prompt.setType(root.get(TYPE_PROPERTY).asText());
        if (root.has(TEMPERATURE_PROPERTY)) {
            prompt.setTemperature(root.get(TEMPERATURE_PROPERTY).asDouble());
        }
        if (root.has(MAX_TOKENS_PROPERTY)) {
            prompt.setMaxTokens(root.get(MAX_TOKENS_PROPERTY).asInt());
        }
        if (root.has(OWNER_PROPERTY)) {
            prompt.setOwner(root.get(OWNER_PROPERTY).asText());
        }
        if (root.has(MODEL_PROPERTY)) {
            prompt.setModel(root.get(MODEL_PROPERTY).asText());
        }
    }
}

