/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import java.util.Base64;

public class ClaudeContent {
    private static final long AUTO_CACHE_TEXT_THRESHOLD = 10000L;
    private static final long AUTO_CACHE_BYTES_THRESHOLD = 1000000L;
    private final Type type;
    private final String text;
    private final String mediaType;
    private final byte[] bytes;
    private final CacheControl cacheControl;

    ClaudeContent(String text, CacheControl cacheControl) {
        this.type = Type.TEXT;
        this.text = text;
        this.bytes = new byte[0];
        this.mediaType = "text/plain";
        this.cacheControl = cacheControl;
    }

    ClaudeContent(byte[] bytes, String mediaType, CacheControl cacheControl) {
        this.type = mediaType.startsWith("image") ? Type.IMAGE : Type.DOCUMENT;
        this.text = "";
        this.bytes = bytes;
        this.mediaType = mediaType;
        this.cacheControl = cacheControl;
    }

    ClaudeContent(String text) {
        this(text, CacheControl.AUTO);
    }

    ClaudeContent(byte[] bytes, String mediaType) {
        this(bytes, mediaType, CacheControl.AUTO);
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.type.toString().toLowerCase();
    }

    public String getText() {
        return this.text;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getBytesAsBase64() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public boolean isCacheControlEnabled() {
        if (this.cacheControl == CacheControl.OFF) {
            return false;
        }
        if (this.cacheControl == CacheControl.ON) {
            return true;
        }
        return (long)this.text.length() > 10000L || (long)this.bytes.length > 1000000L;
    }

    static boolean isValidMediaType(String mediaType) {
        return "image/jpeg".equals(mediaType) || "image/png".equals(mediaType) || "image/gif".equals(mediaType) || "image/webp".equals(mediaType);
    }

    public String getContentAsString() {
        return this.type == Type.TEXT ? this.text : this.getBytesAsBase64();
    }

    public static enum CacheControl {
        AUTO,
        OFF,
        ON;

    }

    public static enum Type {
        TEXT,
        IMAGE,
        DOCUMENT;

    }
}

