/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.pageseeder.ai.anthropic.ClaudeException;
import net.pageseeder.ai.anthropic.ClaudeModel;
import net.pageseeder.ai.anthropic.ClaudeRequest;
import net.pageseeder.ai.anthropic.Endpoint;
import net.pageseeder.ai.anthropic.model.CountTokensResponse;
import net.pageseeder.ai.anthropic.model.ErrorResponse;
import net.pageseeder.ai.anthropic.model.MessageResponse;
import net.pageseeder.ai.anthropic.model.ModelInfo;
import net.pageseeder.ai.anthropic.model.ModelsResponse;
import net.pageseeder.ai.anthropic.model.Response;
import net.pageseeder.ai.anthropic.model.SuccessfulResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicApi {
    public static final String API_VERSION = "2023-06-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnthropicApi.class);
    private final String apiKey;
    private final HttpClient client = HttpClient.newHttpClient();

    public AnthropicApi(String apiKey) {
        this.apiKey = Objects.requireNonNull(apiKey, "API key is required");
    }

    public Response<MessageResponse> postMessage(ClaudeRequest r) throws ClaudeException {
        HttpRequest request = this.buildRequest(Endpoint.MESSAGES, r.toJson());
        return this.fetchResponse(request, MessageResponse.class);
    }

    public Response<CountTokensResponse> countMessageToken(ClaudeRequest r) throws ClaudeException {
        HttpRequest request = this.buildRequest(Endpoint.COUNT_MESSAGE_TOKENS, r.toJson());
        return this.fetchResponse(request, CountTokensResponse.class);
    }

    public Response<ModelsResponse> listModels() throws ClaudeException {
        HttpRequest request = this.buildRequest(Endpoint.LIST_MODELS);
        return this.fetchResponse(request, ModelsResponse.class);
    }

    public Response<ModelInfo> getModel(String modelId) throws ClaudeException {
        HttpRequest request = this.buildRequest(Endpoint.GET_MODEL, Map.of("model_id", modelId));
        return this.fetchResponse(request, ModelInfo.class);
    }

    protected <T extends SuccessfulResponse> Response<T> fetchResponse(HttpRequest request, Class<T> responseClass) throws ClaudeException {
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            return AnthropicApi.toResponse(response, responseClass);
        }
        catch (IOException ex) {
            throw new ClaudeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ClaudeException("Thread was interrupted during HTTP call", ex);
        }
    }

    private HttpRequest buildRequest(Endpoint endpoint) {
        return this.newRequestBuilder(endpoint).GET().build();
    }

    private HttpRequest buildRequest(Endpoint endpoint, String data) {
        return this.newRequestBuilder(endpoint).POST(HttpRequest.BodyPublishers.ofString(data)).header("content-type", "application/json").build();
    }

    private HttpRequest buildRequest(Endpoint endpoint, Map<String, String> pathParameters) {
        return this.newRequestBuilder(endpoint, pathParameters).GET().build();
    }

    private HttpRequest.Builder newRequestBuilder(Endpoint endpoint) {
        return this.newRequestBuilder(endpoint, Map.of());
    }

    private HttpRequest.Builder newRequestBuilder(Endpoint endpoint, Map<String, String> pathParameters) {
        return HttpRequest.newBuilder().uri(URI.create("https://api.anthropic.com" + endpoint.getPath(pathParameters))).header("x-api-key", this.apiKey).header("anthropic-version", API_VERSION);
    }

    private static <T extends SuccessfulResponse> Response<T> toResponse(HttpResponse<String> response, Class<T> responseClass) throws IOException {
        int statusCode = response.statusCode();
        ObjectMapper mapper = new ObjectMapper();
        if (statusCode == 200) {
            return new Response<SuccessfulResponse>(statusCode, (SuccessfulResponse)mapper.readValue(response.body(), responseClass));
        }
        return Response.error(statusCode, (ErrorResponse)mapper.readValue(response.body(), ErrorResponse.class));
    }

    public static String getApiKey() {
        String apiKey = System.getProperty("anthropic.api.key");
        if (apiKey != null) {
            return apiKey;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream("local.properties");){
            properties.load(fis);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load local.properties file");
        }
        apiKey = properties.getProperty("anthropic.api.key", "");
        if (apiKey.isEmpty()) {
            throw new IllegalStateException("Anthropic API key not found in local.properties or system property");
        }
        return apiKey;
    }

    public static void main(String[] args) throws Exception {
        String apiKey = AnthropicApi.getApiKey();
        AnthropicApi api = new AnthropicApi(apiKey);
        ClaudeRequest request = new ClaudeRequest("Hi Claude, how should I format tables for you?");
        request.setModel(ClaudeModel.CLAUDE_4_5_SONNET_20250929);
        Response<MessageResponse> r = api.postMessage(request);
        r.print(System.out);
    }
}

