<!--
  Title of section of element document type
-->
<sch:pattern id="title_section" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Title section</sch:title>

  <sch:rule context="section[@id='title']">

    <sch:assert test="count(fragment) = 1">The title section should only
      contain one fragment.</sch:assert>

    <sch:assert test="count(fragment/heading[@level=1]) = 1">There should be one and
      only one Heading level 1 (H1)</sch:assert>

    <sch:assert test="not(fragment/*[not(self::heading[@level=1])])">The title fragment
      can only contain a Heading level 1 (H1)</sch:assert>

    <sch:assert test="matches(fragment/heading[@level=1], '&lt;[a-z-]+>')">The title fragment
      can only contain the element name as `&lt;element-name&gt;`.</sch:assert>

  </sch:rule>

</sch:pattern>
