<!--
  Check that headings have to correct levels for the table of contents.
-->
<sch:pattern id="heading_toc" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="heading[@level='1']">

    <!-- A heading 1 MUST BE the title of the page -->
    <sch:assert test="not(preceding::fragment|preceding::section|preceding::heading)"
                id="heading_h1"
                properties="fragment" flag="warning"
    >A heading level 1 (H1) MUST be the first heading of the document and appear in the first fragment of the first section.
      But heading &#x201C;<sch:value-of select="."/>&#x201D; is not.
    </sch:assert>

  </sch:rule>

  <sch:rule context="heading[not(preceding::heading)]">

    <!-- Title of the page MUST BE a heading level 1 -->
    <sch:assert test="@level = 1"
                id="heading_h1_first"
                properties="fragment" >The first heading of a document MUST have level 1.
      But heading &#x201C;<sch:value-of select="."/>&#x201D; does not.
    </sch:assert>

  </sch:rule>

  <sch:rule context="heading[preceding::heading]">

    <sch:let name="section" value="ancestor::section"/>

    <!-- The immediately preceding heading -->
    <sch:let name="previous-heading" value="if ($section/title)
        then preceding::heading[1][ancestor::section/@id = $section/@id]
        else preceding::heading[1]"/>

    <!-- The immediately preceding heading -->
    <sch:let name="previous-level" value="
       if ($previous-heading) then number($previous-heading/@level)
       else if ($section/title) then 2 else 0"/>

    <!-- Headings SHOULD NOT jump levels -->
    <sch:report test="not(@level - $previous-level le 1) and $previous-heading"
                id="heading_skip"
                properties="fragment" flag="warning"
    >Do not jump heading levels.
      Heading level <sch:value-of select="@level"/> &#x201C;<sch:value-of select="."/>&#x201D; follows
      heading level <sch:value-of select="$previous-level"/> &#x201C;<sch:value-of select="$previous-heading"/>&#x201D;.
    </sch:report>

    <!-- Headings SHOULD NOT jump levels -->
    <sch:report test="not(@level - $previous-level le 1) and not($previous-heading)"
                id="heading_skip2"
                properties="fragment" flag="warning"
    >Do not jump heading levels.
      Heading level <sch:value-of select="@level"/> &#x201C;<sch:value-of select="."/>&#x201D; follows
      section title &#x201C;<sch:value-of select="$section/title"/>&#x201D;.
    </sch:report>

    <!-- Headings MUST NOT end with ':' -->
    <sch:assert test="not(ends-with(normalize-space(.), ':'))"
                id="heading_colon"
                properties="fragment" flag="warning"
    >A heading MUST NOT end with a colon &#x2018;:&#x2019;,
      but heading &#x201C;<sch:value-of select="."/>&#x201D;  does.</sch:assert>

    <!-- Headings MUST NOT have trailing/leading spaces -->
    <sch:assert test="normalize-space(.) = ."
                id="heading_spaces"
                properties="fragment" flag="warning"
    >A heading MUST NOT have leading/trailing spaces,
      but heading &#x201C;<sch:value-of select="."/>&#x201D; does.</sch:assert>

    <!-- Headings SHOULD be less than 50 characters -->
    <sch:report test="string-length(.) gt 50 and string-length(.) le 80"
                id="heading_length_warn"
                properties="fragment" flag="tip"
    >A heading SHOULD NOT be longer than 50 characters,
      but heading &#x201C;<sch:value-of select="."/>&#x201D; does.</sch:report>

    <!-- Headings MUST be less than 80 characters -->
    <sch:assert test="string-length(.) le 80"
                id="heading_length_error"
                properties="fragment" flag="warning"
    >A heading MUST NOT be longer than 80 characters,
      but heading  &#x201C;<sch:value-of select="."/>&#x201D; is.</sch:assert>

  </sch:rule>

</sch:pattern>
