
<!--
  Checks for title case capitalization

  In title case, major words are capitalized, and most minor words are lowercase.
  - major words: Nouns, verbs (including linking verbs), adjectives, adverbs, pronouns,
    and all words of four letters or more are considered major words.
  - minor words: Short (i.e., three letters or fewer) conjunctions, short prepositions,
    and all articles are considered minor words.

  In title case, capitalize the following words in a title or heading:
  - the first word of the title or heading, even if it is a minor word such as “The” or “A”
  - the first word of a subtitle
  - the first word after a colon, em dash, or end punctuation in a heading
  - major words, including the second part of hyphenated major words (e.g., “Self-Report,” not “Self-report”)
  - words of four letters or more (e.g., “With,” “Between,” “From”)

  Lowercase only minor words that are three letters or fewer in a title or heading
    (except the first word in a title or subtitle or the first word after a colon,
    em dash, or end punctuation in a heading):
  - short conjunctions (e.g., “and,” “as,” “but,” “for,” “if,” “nor,” “or,” “so,” “yet”)
  - articles (“a,” “an,” “the”)
  - short prepositions (e.g., “as,” “at,” “by,” “for,” “in,” “of,” “off,” “on,” “per,” “to,” “up,” “via”)

-->
<sch:pattern id="heading_title_case" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- Match any heading -->
  <sch:rule context="heading">

    <!-- Every term that is at least 4 letters long or is at the start should be capitalized -->
    <sch:assert test="every $word in tokenize(.,'\W+') satisfies
                        if (string-length($word) ge 4 or position() = 1)
                           then substring($word, 1, 1) = upper-case(substring($word, 1, 1)) and substring($word, 2) = lower-case(substring($word, 2))
                           else $word = lower-case($word)"
                properties="fragment"
    >A heading should use title case,
      but heading &#x201C;<sch:value-of select="."/>&#x201D; is not.</sch:assert>

  </sch:rule>

</sch:pattern>
