<!--
  Check that headings have to correct levels for the table of contents.
-->
<sch:pattern id="cell_values" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="cell[para]">

    <sch:assert test="count(* except br) gt 1"
                id="cell_single_para"
                properties="fragment" flag="warning"
    >Found table cell text &#x201C;<sch:value-of select="para"/>&#x201D; in a single paragraph.
      Unwrap the text from paragraph.</sch:assert>
  </sch:rule>

  <sch:rule context="cell[not(*)][text()][string-length(text()) lt 72]">

    <sch:assert test="not(ends-with(text(), '.'))"
                id="cell_period"
                properties="fragment" flag="warning"
    >Don't put periods at the end of short table cell values.
      Remove period from &#x201C;<sch:value-of select="."/>&#x201D;.</sch:assert>
  </sch:rule>

</sch:pattern>
