<!--
  Only words and acronyms in a specified list are allowed to be in all capitals.
-->
<sch:pattern id="allowed_all_caps" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- Specify list of words and acronyms that be in all capital letters -->
  <sch:let name="allowed-all-capitals" value="('COVID')"/>

  <!-- Match any block-level element (except preformat) -->
  <sch:rule context="para|block|cell|hcell|item|heading">

    <sch:let name="all-capitals-words"
             value="tokenize(., '[^a-zA-Z]+')[string-length(.) gt 1]
                      [. = upper-case(.) and empty(index-of($allowed-all-capitals, .))]"/>

    <sch:assert test="empty($all-capitals-words)"
                properties="fragment"
    >Found <sch:value-of select="count($all-capitals-words)"/> word(s) in capital letters:
      <sch:value-of select="string-join($all-capitals-words, ', ')"/>.</sch:assert>

  </sch:rule>

</sch:pattern>