<!--
  ~ Copyright (c) 1999-2023. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:xs="http://www.w3.org/2001/XMLSchema"
     xmlns:psf="http://www.pageseeder.com/function"
     exclude-result-prefixes="#all">

  <xsl:param name="root-document-type" />
  <xsl:param name="def-search" />
  <xsl:param name="def-folder" />

  <xsl:variable name="definitions" select="document(replace($def-search,'\\','/'))" />
  <xsl:variable name="root" select="/document" />

  <xsl:key name="definition" match="inline[@label='definition']" use="lower-case(.)"/>

  <!-- add document label for publication root document type -->
  <xsl:template match="uri[@documenttype=$root-document-type]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="*[not(name()='labels')]"/>
      <labels>
        <xsl:value-of select="$root-document-type"/>
        <xsl:if test="normalize-space(labels) != ''">
          <xsl:value-of select="concat(',',labels)" />
        </xsl:if>
      </labels>
    </xsl:copy>
  </xsl:template>

  <!-- add fragment type as a fragment label - ->
  <xsl:template match="fragment[@type]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='labels')]"/>
      <xsl:attribute name="labels">
        <xsl:value-of select="translate(@type,'.','_')"/>
        <xsl:if test="normalize-space(@labels) != ''">
          <xsl:value-of select="concat(',',@labels)" />
        </xsl:if>
      </xsl:attribute>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template> -->

  <!-- add inline labels at the start of figure caption so they can become fieldcodes -->
  <xsl:template match="para[@prefix and parent::block/@label='figure-caption']">
    <para>
      <xsl:value-of select="concat(substring-before(@prefix,' '),' ')"/>
      <inline label="figure-num-1"><xsl:value-of select="substring-after(substring-before(@prefix,'-'),' ')"/></inline>
      <xsl:text>-</xsl:text>
      <inline label="figure-num-2"><xsl:value-of select="substring-after(@prefix,'-')"/></inline>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="node()" />
    </para>
  </xsl:template>

  <!-- add inline labels at the start of table caption so they can become fieldcodes -->
  <xsl:template match="para[@prefix and parent::block/@label='table-caption']">
    <para>
      <xsl:value-of select="concat(substring-before(@prefix,' '),' ')"/>
      <inline label="table-num-1"><xsl:value-of select="substring-after(substring-before(@prefix,'-'),' ')"/></inline>
      <xsl:text>-</xsl:text>
      <inline label="table-num-2"><xsl:value-of select="substring-after(@prefix,'-')"/></inline>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="node()" />
    </para>
  </xsl:template>

  <!-- convert caption xref to manual as word can't autonumber these -->
  <xsl:template match="xref[@config='caption']">
    <xref display="manual" title="{.}">
      <xsl:copy-of select="@*[not(name()='display' or name()='title')]" />
      <xsl:apply-templates select="node()"/>
    </xref>
  </xsl:template>

  <!-- insert definitions into glossary document -->
  <xsl:template match="section[ends-with(@id,'-definitions') and parent::document/@type='glossary']">
    <xsl:copy>
      <xsl:copy-of select="@*" />
      <xref-fragment id="definitions">
        <xsl:for-each select="$definitions//result">
          <xsl:sort select="field[@name='pstitle']" />

          <!-- if used in document -->
          <xsl:if test="psf:definition-required(field[@name='pstitle']) or
                        psf:definition-required(field[@name='psproperty-synonym'])">
            <blockxref uriid="{field[@name='psid']}" frag="default" type="embed">
              <xsl:apply-templates select="document(concat(replace($def-folder,'\\','/'),
                                   substring-after(field[@name='psfolder'],'/ps'),'/',
                                   field[@name='psfilename']))" />
            </blockxref>
          </xsl:if>
        </xsl:for-each>
      </xref-fragment>
    </xsl:copy>
  </xsl:template>

  <!-- remove properties-fragment from defintion -->
  <xsl:template match="properties-fragment[ancestor::document/@type='definition']">
  </xsl:template>

  <!-- modify definition inline labels to point to glossary -->
  <xsl:template match="inline[@label='definition']">
    <xsl:variable name="lc"
                  select="lower-case(.)" />
    <xsl:variable name="lc-singular"
                  select="if (ends-with(.,'s'))
                           then lower-case(substring(., 1, string-length(.)-1))
                           else lower-case(.)" />
    <xsl:variable name="matches"
                  select="$definitions//result[field[
                         (@name='pstitle' and (lower-case(.)=$lc or lower-case(.)=$lc-singular)) or
                         (@name='psproperty-synonym' and (lower-case(.)=$lc or lower-case(.)=$lc-singular))]]" />
    <!-- only link defintions with a single match, referenced in document -->
    <xsl:choose>
      <xsl:when test="count($matches) = 1 and
                      (key('definition', $lc, $root) or key('definition', $lc-singular, $root))">
        <xref href="{concat('#',$matches/field[@name='psid'])}" frag="default"
              type="none" config="definition" display="manual" title="{.}">
          <xsl:value-of select="." />
        </xref>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:copy-of select="@*" />
          <xsl:apply-templates select="node()" />
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- checks if a list of terms or terms + 's' requires a definition -->
  <xsl:function name="psf:definition-required" as="xs:boolean">
    <xsl:param name="terms" as="element(field)*"/>
    <xsl:variable name="matches">
      <xsl:for-each select="$terms">
        <xsl:sequence select="key('definition', lower-case(.), $root)" />
        <xsl:sequence select="key('definition', lower-case(concat(.,'s')), $root)" />
      </xsl:for-each>
    </xsl:variable>
    <xsl:sequence select="count($matches/inline) gt 0" />
  </xsl:function>

</xsl:stylesheet>