<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-group-validation']" mode="json">
  <xsl:variable name="name" select="header//parameter[@name = 'name']" />
  <xsl:variable name="shared" select="$name != '' and $name != 'validation_output.xml'" />
  <json:map>
    <xsl:for-each select="content/validation-report">
      <json:map key="report">
        <json:string key="name"><xsl:value-of select="if ($shared) then translate(replace($name, '.xml', ''), '_', ' ') else 'private report'" /></json:string>
        <json:string key="filename"><xsl:value-of select="if ($shared) then $name else 'validation_output.xml'" /></json:string>
        <json:boolean key="shared"><xsl:value-of select="$shared" /></json:boolean>
        <json:boolean key="global"><xsl:value-of select="@for = 'server'" /></json:boolean>
        <json:boolean key="urls"><xsl:value-of select="exists(@urltype)" /></json:boolean>
        <json:string key="urltype"><xsl:value-of select="@urltype" /></json:string>
        <json:number key="documents"><xsl:value-of select="@documents"/></json:number>
        <json:string key="date"><xsl:value-of select="@date"/></json:string>
        <json:string key="schema"><xsl:value-of select="@schema"/></json:string>
        <json:string key="publicationid"><xsl:value-of select="@publicationid"/></json:string>
        <json:string key="publicationTitle"><xsl:value-of select="@publication-title"/></json:string>
        <json:boolean key="failuresOnly"><xsl:value-of select="@failures-only = 'true'" /></json:boolean>
        <xsl:if test="@include-subdirectories"><json:boolean key="includeSubdirectories"><xsl:value-of select="@include-subdirectories = 'true'"/></json:boolean></xsl:if>
        <xsl:if test="@extension"><json:string key="extension"><xsl:value-of select="@extension"/></json:string></xsl:if>
        <xsl:if test="@documenttype"><json:string key="documentType"><xsl:value-of select="@documenttype"/></json:string></xsl:if>
        <xsl:if test="@folder"><json:string key="folder"><xsl:value-of select="@folder"/></json:string></xsl:if>
        <xsl:if test="@folderuri"><json:number key="folderuri"><xsl:value-of select="@folderuri"/></json:number></xsl:if>
        <json:array key="ids">
          <xsl:for-each select="tokenize(@ids, ',')"><json:number><xsl:value-of select="." /></json:number></xsl:for-each>
        </json:array>
        <json:array key="results">
          <!-- We flatten the result to make it easier to process -->
          <xsl:for-each select="uri">
            <xsl:sort select="@title" />
            <xsl:apply-templates select=".//svrl:successful-report|.//svrl:failed-assert" mode="json">
              <xsl:with-param name="uriid" select="@id"/>
              <xsl:with-param name="uripath"  select="@path"/>
              <xsl:with-param name="urititle"  select="@title"/>
            </xsl:apply-templates>
          </xsl:for-each>
        </json:array>
      </json:map>
    </xsl:for-each>
    <xsl:if test="not(content/validation-report)">
      <json:null key="report"/>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-group-validation-reports']" mode="json">
  <json:array>
    <xsl:for-each select="content/validations/validation">
      <json:map>
        <json:boolean key="shared">true</json:boolean>
        <json:boolean key="global"><xsl:value-of select="ends-with(@name, '_global.xml')" /></json:boolean>
        <json:string key="name"><xsl:value-of select="translate(replace(@name, '.xml', ''), '_', ' ')" /></json:string>
        <json:string key="filename"><xsl:value-of select="@name" /></json:string>
        <json:string key="date"><xsl:value-of select="@created" /></json:string>
      </json:map>
    </xsl:for-each>
    <xsl:for-each select="content/validation-report">
      <json:map>
        <json:boolean key="shared">false</json:boolean>
        <json:boolean key="global"><xsl:value-of select="@for = 'server'" /></json:boolean>
        <json:string key="name">private report</json:string>
        <json:string key="filename">validation_output.xml</json:string>
        <json:string key="date"><xsl:value-of select="@date"/></json:string>
        <xsl:if test="@schema">
          <json:string key="schema"><xsl:value-of select="@schema"/></json:string>
        </xsl:if>
        <json:array key="results">
          <xsl:for-each select="uri">
            <json:map>
              <json:number key="uriid"><xsl:value-of select="@id"/></json:number>
              <json:string key="uripath"><xsl:value-of select="@path"/></json:string>
              <json:string key="title"><xsl:value-of select="@title"/></json:string>
              <xsl:variable name="uriid" select="@id"/>
              <xsl:apply-templates select="svrl:schematron-output" mode="json">
                <xsl:with-param name="uriid" select="$uriid"/>
              </xsl:apply-templates>
            </json:map>
          </xsl:for-each>
        </json:array>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="root[@service='api-document-validate']" mode="json">
  <json:map>
    <xsl:for-each select="content/validation">
      <xsl:variable name="uriid" select="@uriid"/>
      <json:number key="uriid"><xsl:value-of select="@uriid"/></json:number>
      <json:string key="status"><xsl:value-of select="@status"/></json:string>
      <xsl:if test="@error">
        <json:string key="error"><xsl:value-of select="@error"/></json:string>
      </xsl:if>
      <xsl:if test="@schema">
        <json:string key="schema"><xsl:value-of select="@schema"/></json:string>
      </xsl:if>
      <xsl:apply-templates select="//svrl:schematron-output" mode="json">
        <xsl:with-param name="uriid" select="$uriid"/>
      </xsl:apply-templates>
    </xsl:for-each>
  </json:map>
</xsl:template>

<!-- TODO Mode SVRL stuff to `_common/json.xsl` when ready -->

<xsl:template match="svrl:schematron-output" mode="json">
  <xsl:param name="uriid" />
  <json:map key="schematronOutput">
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:array key="results">
      <xsl:apply-templates select=".//svrl:successful-report|.//svrl:failed-assert" mode="json">
        <xsl:with-param name="uriid" select="$uriid"/>
      </xsl:apply-templates>
    </json:array>
  </json:map>
</xsl:template>

<!-- Successful report and failed assertions (SVRL) -->
<xsl:template match="svrl:successful-report|svrl:failed-assert" mode="json">
  <xsl:param name="uriid" />
  <xsl:param name="uripath" />
  <xsl:param name="urititle" />
  <json:map>
    <xsl:if test="@id">
      <!-- ID of the assert or report for filtering (optional) -->
      <json:string key="id"><xsl:value-of select="@id"/></json:string>
    </xsl:if>
    <!-- Unique ID for the result to facilitate sorting in frontend -->
    <json:string key="resultId"><xsl:value-of select="f:generate-svrl-id(., $uriid)"/></json:string>
    <json:string key="type"><xsl:value-of select="local-name()"/></json:string>
    <json:string key="location"><xsl:value-of select="@location"/></json:string>
    <json:string key="test"><xsl:value-of select="@test"/></json:string>
    <json:string key="text"><xsl:value-of select="svrl:text"/></json:string>
    <xsl:if test="@flag">
      <json:string key="flag"><xsl:value-of select="@flag"/></json:string>
    </xsl:if>
    <xsl:if test="@role">
      <json:string key="role"><xsl:value-of select="@role"/></json:string>
    </xsl:if>
    <xsl:if test="svrl:diagnostic-reference">
      <json:map key="diagnostics">
        <xsl:for-each select="svrl:diagnostic-reference">
          <json:string key="{@diagnostic}"><xsl:value-of select="."/></json:string>
        </xsl:for-each>
      </json:map>
    </xsl:if>
    <xsl:if test="svrl:property-reference[not(@role='quickfix')]">
      <json:map key="properties">
        <xsl:for-each select="svrl:property-reference[not(@role='quickfix')]">
          <json:string key="{@property}"><xsl:value-of select="."/></json:string>
        </xsl:for-each>
      </json:map>
    </xsl:if>
    <xsl:if test="svrl:property-reference[@role='quickfix']">
      <json:array key="quickfixes">
        <xsl:for-each select="svrl:property-reference[@role='quickfix']">
          <json:map>
            <json:string key="id"><xsl:value-of select="@property"/></json:string>
            <json:string key="description"><xsl:value-of select="if (descendant::parameter) then descendant::description else ."/></json:string>
            <json:map key="parameters">
              <xsl:for-each select="descendant::parameter">
                 <json:string key="{@name}"><xsl:value-of select="."/></json:string>
              </xsl:for-each>
            </json:map>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:if test="$uriid">
      <json:number key="uriid"><xsl:value-of select="$uriid"/></json:number>
    </xsl:if>
    <xsl:if test="$uripath">
      <json:string key="uripath"><xsl:value-of select="$uripath"/></json:string>
    </xsl:if>
    <xsl:if test="$urititle">
      <json:string key="urititle"><xsl:value-of select="$urititle"/></json:string>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:function name="f:generate-svrl-id">
  <xsl:param name="result"/>
  <xsl:param name="uriid"/>
  <xsl:value-of>
    <xsl:if test="$uriid"><xsl:value-of select="$uriid"/>/</xsl:if>
    <xsl:value-of select="if (local-name($result) = 'successful-report') then 'R' else 'F'"/>
    <xsl:value-of select="count($result/preceding-sibling::*[local-name() = local-name($result)])"/>
  </xsl:value-of>
</xsl:function>

</xsl:stylesheet>
