<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- General logs -->
<xsl:template match="root[@service='api-project-admin-files']" mode="json">
  <json:array>
    <xsl:apply-templates select="content/file" mode="json-files"/>
  </json:array>
</xsl:template>

<xsl:template match="file" mode="json-files">
  <json:map>
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="path"><xsl:value-of select="@path"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <xsl:if test="@type = 'file'">
      <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
      <xsl:if test="@length">
        <json:number key="length"><xsl:value-of select="@length"/></json:number>
      </xsl:if>
      <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
      <json:boolean key="text"><xsl:value-of select="@text = 'true'"/></json:boolean>
      <json:boolean key="overrides"><xsl:value-of select="@overrides = 'true'"/></json:boolean>
    </xsl:if>
    <xsl:if test="@type = 'folder'">
      <json:array key="files">
        <xsl:apply-templates select="file" mode="json-files"/>
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

</xsl:stylesheet>
