<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-tracker-split']" mode="json">
  <xsl:variable name="left">
    <xsl:for-each select="content/document">
      <document tracking="ins">
        <xsl:copy-of select="@*"/>
        <documentinfo>
          <xsl:copy-of select="documentinfo/uri|documentinfo/reversexrefs"/>
        </documentinfo>
        <xsl:copy-of select="metadata|toc"/>
        <xsl:apply-templates select="section" mode="copy-tracker-split" />
        <!-- For use by diff elements -->
        <xsl:copy-of select="descendant::edits/edit"/>
      </document>
    </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="right">
    <xsl:for-each select="content/document">
      <document tracking="del">
        <xsl:copy-of select="@* except @date|@version"/>
        <xsl:copy-of select="documentinfo/compareto/(@date|@version)"/>
        <documentinfo>
          <xsl:copy-of select="documentinfo/uri|documentinfo/reversexrefs"/>
        </documentinfo>
        <xsl:for-each select="documentinfo/compareto/structure/document/*">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:for-each select="fragment-ref">
              <xsl:variable name="id" select="@id"/>
              <xsl:variable name="diff" select="ancestor::document/fragmentinfo/locator[@fragment=$id]/compare/diff/*"/>
              <xsl:apply-templates select="if ($diff) then $diff else ancestor::document/section/*[@id=$id]" mode="copy-tracker-split" />
            </xsl:for-each>
          </xsl:copy>
        </xsl:for-each>

        <!-- For use by diff elements -->
        <xsl:copy-of select="descendant::edits/edit"/>
      </document>
    </xsl:for-each>
  </xsl:variable>
  <json:map>
    <xsl:apply-templates select="$left" mode="json-document">
      <xsl:with-param name="key" select="'left'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="$right" mode="json-document">
      <xsl:with-param name="key" select="'right'"/>
    </xsl:apply-templates>
    <!-- We need to include the edits because they are not all in the locator -->
    <json:array key="edits">
      <!-- Can be `draft` or `edit` -->
      <xsl:for-each select="content/document//edits/edit">
        <json:map>
          <json:number key="id"><xsl:value-of select="@id" /></json:number>
          <json:string key="created"><xsl:value-of select="@created" /></json:string>
          <xsl:apply-templates select="author" mode="json" />
          <xsl:if test="notes/note">
            <json:array key="notes">
              <xsl:apply-templates select="notes/note" mode="json-document" />
            </json:array>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<!-- Copy sections -->
<xsl:template match="*" mode="copy-tracker-split">
  <xsl:copy>
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates mode="#current"/>
  </xsl:copy>
</xsl:template>

<!-- Inject @labels in fragments -->
<xsl:template match="fragment|media-fragment|properties-fragment|xref-fragment" mode="copy-tracker-split">
  <xsl:copy>
    <xsl:attribute name="labels"><xsl:value-of select="//locator[@fragment = current()/@id]/labels"/></xsl:attribute>
    <xsl:copy-of select="@* except @labels"/>
    <xsl:copy-of select="text()|*"/>
  </xsl:copy>
</xsl:template>

<!-- Inject @labels in fragments -->
<xsl:template match="diff/fragment|diff/media-fragment|diff/properties-fragment|diff/xref-fragment" mode="copy-tracker-split">
  <xsl:copy>
    <xsl:attribute name="labels"><xsl:value-of select="//locator[@fragment = current()/@id]/compare/labels"/></xsl:attribute>
    <xsl:copy-of select="@* except @labels"/>
    <xsl:copy-of select="text()|*"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
