<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-fragment-transform'
                       or @service='api-document-fragment-transform-preview']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/fragment-transform" mode="api-document-fragment"/>
  </json:map>
</xsl:template>

<xsl:template match="fragment-transform" mode="api-document-fragment">
  <xsl:apply-templates select="fragment|media-fragment|properties-fragment|xref-fragment" mode="json-document">
    <xsl:with-param name="key" select="'fragment'"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="metadata" mode="api-document-fragment">
  <xsl:apply-templates select="." mode="json-document">
    <xsl:with-param name="key" select="'fragment'"/>
  </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>
