<!--
  ~ Copyright (c) 1999-2024. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-ai-answer']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/ai" mode="api-document-ai-answer"/>
  </json:map>
</xsl:template>

<xsl:template match="ai" mode="api-document-ai-answer">
  <json:string key="prompt"><xsl:value-of select="@prompt"/></json:string>
  <json:string key="model"><xsl:value-of select="@model"/></json:string>
  <json:string key="response"><xsl:value-of select="response"/></json:string>
  <json:string key="psml"><xsl:value-of select="psml"/></json:string>
  <json:string key="html"><xsl:value-of select="html"/></json:string>
</xsl:template>

<xsl:template match="root[@service='api-document-ai-preview']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/prompt" mode="ai">
      <xsl:with-param name="key" select="'prompt'"/>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-document-ai-prompts']" mode="json">
  <json:map>
    <json:array key="promptTemplates">
      <xsl:for-each select="content/prompt-templates">
        <xsl:apply-templates mode="ai"/>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="prompt" mode="ai">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="id"><xsl:value-of select="@id"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:string key="model"><xsl:value-of select="@model"/></json:string>
    <json:number key="maxTokens"><xsl:value-of select="@max-tokens"/></json:number>
    <json:string key="system"><xsl:value-of select="system"/></json:string>
    <json:array key="content">
      <xsl:for-each select="contents/content">
        <json:map>
          <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
          <json:string key="text"><xsl:value-of select="text"/></json:string>
        </json:map>
      </xsl:for-each>
    </json:array>
    <json:string key="html"><xsl:value-of select="html"/></json:string>
  </json:map>
</xsl:template>

<xsl:template match="prompt-template" mode="ai">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="id"><xsl:value-of select="@id"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:number key="maxTokens"><xsl:value-of select="@max-tokens"/></json:number>
    <json:number key="temperature"><xsl:value-of select="@temperature"/></json:number>
    <json:string key="system"><xsl:value-of select="system"/></json:string>

    <json:array key="placeholders">
      <xsl:for-each select="placeholders/placeholder">
        <json:string><xsl:value-of select="@name"/></json:string>
      </xsl:for-each>
    </json:array>
    <json:array key="user">
      <xsl:for-each select="user">
        <xsl:apply-templates select="text|attachment" mode="prompt-template" />
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="text" mode="prompt-template">
  <json:map>
    <json:string key="text"><xsl:value-of select="."/></json:string>
  </json:map>
</xsl:template>

<xsl:template match="attachment" mode="prompt-template">
  <json:map>
    <json:string key="ref"><xsl:value-of select="@ref"/></json:string>
  </json:map>
</xsl:template>

</xsl:stylesheet>
