<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-threads']" mode="json">
<json:map>
  <json:array key="threads">
    <xsl:for-each select="content/threads/thread">
      <json:map>
        <json:string key="id"><xsl:value-of select="@id"/></json:string>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="username"><xsl:value-of select="@username"/></json:string>
        <json:string key="started"><xsl:value-of select="@started"/></json:string>
        <json:string key="group"><xsl:value-of select="if (@groupname) then @groupname else @groupid"/></json:string>
        <json:string key="status"><xsl:value-of select="@status"/></json:string>
        <json:string key="message"><xsl:value-of select="message"/></json:string>
        <xsl:choose>
          <xsl:when test="progress">
            <xsl:apply-templates select="progress" mode="api-admin-status"/>
          </xsl:when>
          <xsl:when test="action">
            <xsl:if test="string(action) != ''">
              <json:string key="action"><xsl:value-of select="action"/></json:string>
            </xsl:if>
            <xsl:apply-templates select="action" mode="api-admin-status"/>
          </xsl:when>
          <xsl:when test="processing | packaging">
            <xsl:apply-templates select="processing | packaging" mode="api-admin-status"/>
          </xsl:when>
          <xsl:when test="indexing/progress">
            <xsl:apply-templates select="indexing/progress" mode="api-admin-status"/>
          </xsl:when>
          <xsl:when test="@status = 'completed'">
            <json:map key="progress"><json:number key="percent">100</json:number></json:map>
          </xsl:when>
        </xsl:choose>
      </json:map>
    </xsl:for-each>
  </json:array>
</json:map>
</xsl:template>

<xsl:template match="progress|processing|packaging|indexing/progress|action" mode="api-admin-status">
  <json:map key="progress">
    <json:number key="current"><xsl:value-of select="@current"/></json:number>
    <json:number key="total"><xsl:value-of select="@total"/></json:number>
    <json:number key="percent">
      <xsl:choose>
        <xsl:when test="@total &gt; 0"><xsl:value-of select="@current*100 idiv @total"/></xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </json:number>
  </json:map>
</xsl:template>

</xsl:stylesheet>
