<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-oauth-clients']" mode="json">
  <json:array>
    <xsl:apply-templates select="//client" mode="json" />
  </json:array>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-code-issue']" mode="json">
  <json:map>
    <xsl:for-each select="//authorization-code-issue">
      <xsl:apply-templates select="authorization-code" mode="json">
        <xsl:with-param name="key" select="'authorizationCode'"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="client" mode="json">
        <xsl:with-param name="key">client</xsl:with-param>
      </xsl:apply-templates>
      <xsl:apply-templates select="member" mode="json">
        <xsl:with-param name="key">member</xsl:with-param>
      </xsl:apply-templates>
    </xsl:for-each>
  </json:map>
</xsl:template>


<xsl:template match="root[@service='api-admin-oauth-access-token-issue']" mode="json">
  <json:map>
    <xsl:apply-templates select="//access-token" mode="json">
      <xsl:with-param name="key" select="'accessToken'"/>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-refresh-token-issue']" mode="json">
  <json:map>
    <xsl:apply-templates select="//persistent-token" mode="json">
      <xsl:with-param name="key" select="'persistentToken'"/>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-codes']" mode="json">
  <json:map>
    <json:boolean key="manualTokenCreation"><xsl:value-of select="//authorization-codes/@manual-token-creation = 'true'" /></json:boolean>
    <json:array key="codes">
      <xsl:apply-templates select="//authorization-code" mode="json"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-access-tokens']" mode="json">
  <json:map>
    <json:boolean key="manualTokenCreation"><xsl:value-of select="//access-tokens/@manual-token-creation = 'true'" /></json:boolean>
    <json:string key="lastPurged"><xsl:value-of select="//access-tokens/@last-purged" /></json:string>
    <json:number key="total"><xsl:value-of select="//access-tokens/@total" /></json:number>
    <json:array key="tokens">
      <xsl:apply-templates select="//access-token" mode="json"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-refresh-tokens']" mode="json">
  <json:map>
    <json:boolean key="manualTokenCreation"><xsl:value-of select="//refresh-tokens/@manual-token-creation = 'true'" /></json:boolean>
    <json:array key="tokens">
      <xsl:apply-templates select="//persistent-token" mode="json"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-webhooks']" mode="json">
  <json:map>
    <json:boolean key="cacheError"><xsl:value-of select="content/webhooks/@cache-error = 'true'" /></json:boolean>
    <json:array key="webhooks">
      <xsl:apply-templates select="//webhook" mode="json" />
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-webhook-event']" mode="json">
  <xsl:apply-templates select="content/webevent" mode="json"/>
</xsl:template>

<xsl:template match="root[@service='api-admin-oauth-webhook-job']" mode="json">
  <xsl:apply-templates select="content/job" mode="json"/>
  <xsl:if test="empty(content/job)">
    <json:map key="error"><json:string key="message">Not found</json:string></json:map>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
