<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<!--
  Main template called in all cases.
-->
<xsl:template match="root[@service='api-admin-member-groups-admin']" mode="json">
  <xsl:variable name="managed-groups" select="//membership[@role='manager'
                                                        or @role='moderator'
                                                        or @role='approver'
                                                        or @role='moderator-and-approver']/(group|project)"/>
  <json:map>
    <xsl:for-each select="content[@name='list-project-as-tree']/projects">
      <json:string key="for"><xsl:value-of select="@for"/></json:string>
      <json:array key="groups">
        <xsl:apply-templates select="project" mode="api-admin-member-groups-admin">
          <xsl:with-param name="managed-groups" select="$managed-groups"/>
        </xsl:apply-templates>
      </json:array>
    </xsl:for-each>
  </json:map>
</xsl:template>

<xsl:template match="group|project" mode="api-admin-member-groups-admin">
  <xsl:param name="managed-groups"/>
  <xsl:variable name="name" select="@name"/>
  <json:map>
    <json:number key="id"><xsl:value-of select="@id"/></json:number>
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:string key="type"><xsl:value-of select="name()"/></json:string>
    <json:string key="description"><xsl:value-of select="@description"/></json:string>
    <json:boolean key="admin">
      <xsl:value-of select="count($managed-groups[@name = $name]) = 1 or //memberships/member/@admin='true'"/>
    </json:boolean>
    <xsl:variable name="children" select="project[descendant-or-self::*/@name = $managed-groups/@name]
                                         |group[@name = $managed-groups/@name]"/>
    <xsl:if test="$children">
      <json:array key="groups">
        <xsl:apply-templates select="$children" mode="api-admin-member-groups-admin">
          <xsl:with-param name="managed-groups" select="$managed-groups"/>
        </xsl:apply-templates>
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

</xsl:stylesheet>