<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='unsubscribe']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Unsubscribe')"/>
</xsl:template>

<xsl:template match="root[@service='unsubscribe']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box>
      <xsl:variable name="unsubscribe" select="//unsubscribe"/>
      <xsl:choose>
        <xsl:when test="$unsubscribe">
          <xsl:apply-templates select="$unsubscribe" mode="unsubscribe"/>
        </xsl:when>
        <xsl:otherwise>
          <public-content>
            <h1 class="page-title">Unsubscribe error</h1>
          </public-content>
          <callout-box type="error"><xsl:value-of select="content/error/message" /></callout-box>
        </xsl:otherwise>
      </xsl:choose>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

<xsl:template match="unsubscribe" mode="unsubscribe">
  <xsl:variable name="memberships">
    <json:array>
      <xsl:apply-templates select="membership" mode="json"/>
    </json:array>
  </xsl:variable>
  <unsubscribe-form group-name="{//parameter[@name='group']}"
                    email="{@email}"
                    token="{//parameter[@name='token']}"
                    v-bind:initial-memberships="{f:xml-to-json($memberships)}"/>
</xsl:template>

</xsl:stylesheet>
