<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='signin']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Sign in')"/>
</xsl:template>

<xsl:template match="root[@service='signin']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box>
      <xsl:variable name="legal-documents">
        <json:array>
          <xsl:for-each select="//ui/legal/document[@agree-on = 'login' or @agree-on = 'all']">
            <json:map>
              <json:string key="name"><xsl:value-of select="@name"/></json:string>
              <json:string key="title"><xsl:value-of select="@title"/></json:string>
            </json:map>
          </xsl:for-each>
        </json:array>
      </xsl:variable>

      <signin-form host="{//resolved-host}"
                   code="{(//parameter[@name='auth_code'])[1]}"
                   client-id="{(//parameter[@name='client_id'])[1]}"
                   location="{(//parameter[@name='location'])[1]}"
                   challenge-authenticator="{//session/@authenticator}"
                   v-bind:legal="{f:xml-to-json($legal-documents)}"/>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
