<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-types']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Document types')"/>
</xsl:template>

<xsl:template match="root[@service='project-types']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">
      <xsl:variable name="project" select="$context/project"/>

      <xsl:if test="$session/permissions[@admin-system='true' or @config-project='true']">
        <a href="{$site-prefix}/ui/p/{$project/@name}/admin/types.html" class="button alert float-right"><svg-icon name="wrench"/> Manage document types</a>
      </xsl:if>

      <h1 class="page-title"><svg-icon name="file-template"/> Document types</h1>

      <xsl:variable name="doctypes">
        <json:array>
          <xsl:for-each select="//document-type">
            <xsl:sort select="lower-case(@name)"/>
            <xsl:apply-templates select="." mode="json-config"/>
          </xsl:for-each>
        </json:array>
      </xsl:variable>

      <project-types v-bind:types="{f:xml-to-json($doctypes)}"/>

      <p>&#xa0;</p>

    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
