<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-tasks']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Tasks')"/>
</xsl:template>

<xsl:template match="root[@service='group-tasks']" mode="main-content">
  <xsl:variable name="assignedto"  select="//http-parameters/parameter[@name='assignedto']"/>
  <xsl:variable name="label"       select="//http-parameters/parameter[@name='label']"/>
  <xsl:variable name="priority"    select="//http-parameters/parameter[@name='priority']"/>
  <xsl:variable name="status"      select="//http-parameters/parameter[@name='status']"/>
  <xsl:variable name="view"        select="//http-parameters/parameter[@name='view']"/>

  <group-tasks-bar statuses="{$status}" priority="{$priority}" label="{$label}">
    <xsl:if test="$assignedto">
      <xsl:attribute name="v-bind:assignedto" select="if ($assignedto = 'me')      then //session/member/@id else
                                                      if ($assignedto = 'nobody')  then 0 else
                                                      if ($assignedto = 'anybody') then -1 else $assignedto" />
    </xsl:if>
    <xsl:if test="$view">
      <xsl:attribute name="view" select="$view" />
    </xsl:if>
    <xsl:if test="ends-with(header/path/@info, '/workflows')">
      <xsl:attribute name="contentrole" select="'workflow'" />
    </xsl:if>
  </group-tasks-bar>

  <div class="main-content">
    <main-panel full-width="">
      <group-tasks />
    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
