<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<!--
  Defines the structure of the default template.
-->
<xsl:template match="root" mode="app-content">
  <div class="app-content">
    <server-message/>
    <session-recorder/>
    <bookmark-handler icon="{f:service-icon(@service)}" title="{f:service-title(@service)}"/>
    <xsl:if test="not(contains(@flags, 'no-header'))">
      <header-bar active-page="{@service}" icon="{f:icon-src(.)}" logo="{f:logo-src(.)}"/>
    </xsl:if>
    <xsl:apply-templates select="." mode="main-content" />
    <infobox-container />
  </div>
</xsl:template>

<!--
  Defines the structure of the admin pages
-->
<xsl:template match="root[@group='admin']" mode="app-content" priority="2">
  <div class="app-content">
    <server-message/>
    <session-recorder/>
    <bookmark-handler icon="{f:service-icon(@service)}" title="{f:service-title(@service)}"/>
    <header-bar active-page="{@service}" admin="" icon="{f:icon-src(.)}" logo="{f:logo-src(.)}"/>
    <div class="main-content">
      <xsl:apply-templates select="." mode="main-side-nav"/>
      <xsl:apply-templates select="." mode="main-content" />
    </div>
    <infobox-container />
  </div>
</xsl:template>

<!--
  Defines the structure of the document pages
-->
<xsl:template match="root[@group='document']" mode="app-content" priority="2">
  <xsl:variable name="publicationid" select="(//parameter[@name = 'publicationid'])[1]"/>
  <xsl:variable name="version" select="(//parameter[@name = 'version'])[1]"/>
  <xsl:variable name="versionid" select="(//parameter[@name = 'versionid'])[1]"/>
  <xsl:variable name="compare" select="(//parameter[@name = 'compare'])[1]"/>
  <xsl:variable name="compareid" select="(//parameter[@name = 'compareid'])[1]"/>
  <xsl:variable name="compareuriid" select="(//parameter[@name = 'compareuriid'])[1]"/>
  <div class="app-content">
    <session-recorder/>
    <document-loader>
      <xsl:if test="$publicationid">
        <xsl:attribute name="initial-publication" select="$publicationid"/>
      </xsl:if>
      <xsl:if test="$version or $versionid">
        <xsl:attribute name="initial-version" select="if ($versionid) then concat('event:', $versionid) else $version"/>
      </xsl:if>
      <xsl:if test="$compare or $compareid">
        <xsl:attribute name="initial-compare" select="if ($compareid) then concat('event:', $compareid) else $compare"/>
      </xsl:if>
      <xsl:if test="$compareuriid">
        <xsl:attribute name="initial-compareuriid" select="$compareuriid"/>
      </xsl:if>
    </document-loader>
    <bookmark-handler icon="{f:service-icon(@service)}" title="{f:service-title(@service)}"/>
    <server-message/>
    <header-bar active-page="{@service}" icon="{f:icon-src(.)}" logo="{f:logo-src(.)}"/>
    <xsl:apply-templates select="." mode="main-content" />
    <infobox-container />
  </div>
</xsl:template>

<!--
  Defines the structure of the public pages
-->
<xsl:template match="root[@group='public']" mode="app-content" priority="2">
  <div class="app-content">
    <server-message/>
    <header class="public-header">
      <site-title logo="{f:logo-src(.)}"/>
    </header>
    <xsl:apply-templates select="." mode="main-content" />
    <xsl:call-template name="public-footer"/>
    <infobox-container />
  </div>
</xsl:template>

<xsl:template name="public-footer">
  <footer class="public-footer">
    <public-content>
      <ul>
        <li class="public-footer_poweredby">Powered by <a href="https://pageseeder.com">
          <img src="{$site-prefix}/weborganic/ui/images/pageseeder-logo.svg" width="128" alt="PageSeeder"/>
        </a> v<b><xsl:value-of select="$version"/></b></li>
        <xsl:for-each select="//ui/legal/document">
          <li class="public-footer_legal">
            <a href="{$site-prefix}/ui/legal/{@name}.html" target="_new"><xsl:value-of select="@title"/></a>
          </li>
        </xsl:for-each>
      </ul>
    </public-content>
  </footer>
</xsl:template>

<xsl:template name="app-footer">
  <footer class="app-footer">
    <ul>
      <li class="app-footer_poweredby">Powered by <a href="https://pageseeder.com">
        <svg-icon name="pslogo" size="24"/>PageSeeder
      </a> v<b><xsl:value-of select="$version"/></b></li>
      <xsl:for-each select="(//ui/legal)[1]/document">
        <li class="app-footer_legal">
          <a href="{$site-prefix}/ui/legal/{@name}.html" target="_new"><xsl:value-of select="@title"/></a>
        </li>
      </xsl:for-each>
    </ul>
  </footer>
</xsl:template>

<xsl:function name="f:logo-src" as="xs:string">
  <xsl:param name="root" as="element(root)"/>
  <xsl:sequence select="f:_org-image-src(($root/content/ui/images/@logo-filename)[1], ($root/content/constants/@global-template)[1], concat($site-prefix, '/weborganic/ui/images/pageseeder-logo.svg'))"/>
</xsl:function>

<xsl:function name="f:icon-src" as="xs:string">
  <xsl:param name="root" as="element(root)"/>
  <xsl:sequence select="f:_org-image-src(($root/content/ui/images/@icon-filename)[1], ($root/content/constants/@global-template)[1], concat($site-prefix, '/weborganic/ui/images/pageseeder-icon.svg'))"/>
</xsl:function>

<xsl:function name="f:_org-image-src" as="xs:string">
  <xsl:param name="filename"      as="xs:string?"/>
  <xsl:param name="global-template" as="xs:string?"/>
  <xsl:param name="default"       as="xs:string"/>
  <xsl:value-of select="if ($filename) then concat($site-prefix, '/woconfig/', $global-template, '/organization/', $filename) else $default"/>
</xsl:function>

<xsl:function name="f:service-icon" as="xs:string?">
  <xsl:param name="service" as="xs:string"/>
  <xsl:choose>
    <xsl:when test="$service = 'admin-dashboard'">dashboard</xsl:when>
    <xsl:when test="$service = 'admin-logs-access'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-general'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-index'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-mail'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-process'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-publish'">logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-recent'">logs</xsl:when>
    <xsl:when test="$service = 'admin-processes'">system-status</xsl:when>
    <xsl:when test="$service = 'admin-system'">system-status</xsl:when>
    <xsl:when test="$service = 'admin-cache'">system-status</xsl:when>
    <xsl:when test="$service = 'admin-indexing'">system-status</xsl:when>
    <xsl:when test="$service = 'admin-publisher'">system-status</xsl:when>
    <xsl:when test="$service = 'admin-administrators'">member-groups</xsl:when>
    <xsl:when test="$service = 'admin-members'">member-groups</xsl:when>
    <xsl:when test="$service = 'admin-members-import'">member-groups</xsl:when>
    <xsl:when test="$service = 'admin-oauth-clients'">handshake</xsl:when>
    <xsl:when test="$service = 'admin-oauth-access-tokens'">handshake</xsl:when>
    <xsl:when test="$service = 'admin-oauth-codes'">handshake</xsl:when>
    <xsl:when test="$service = 'admin-oauth-refresh-tokens'">handshake</xsl:when>
    <xsl:when test="$service = 'admin-oauth-webhooks'">handshake</xsl:when>
    <xsl:when test="$service = 'admin-projects'">group</xsl:when>
    <xsl:when test="$service = 'admin-projects-archived'">group</xsl:when>
    <xsl:when test="$service = 'admin-projects-create'">group</xsl:when>
    <xsl:when test="$service = 'admin-templates'">file-template</xsl:when>
    <xsl:when test="$service = 'admin-files'">file-template</xsl:when>
    <xsl:when test="$service = 'admin-hosts'">cog</xsl:when>
    <xsl:when test="$service = 'admin-organization'">cog</xsl:when>
    <xsl:when test="$service = 'admin-settings'">cog</xsl:when>
    <xsl:when test="$service = 'admin-license'">cog</xsl:when>
    <xsl:when test="$service = 'admin-database'">cog</xsl:when>
    <xsl:when test="$service = 'admin-groups-create'">cog</xsl:when>
    <xsl:when test="$service = 'admin-project-files'">file-template</xsl:when>
    <xsl:when test="$service = 'admin-project-emails'">file-template</xsl:when>
    <xsl:when test="$service = 'admin-project-catalog'">cog</xsl:when>
    <xsl:when test="$service = 'admin-project-scripts'">file-template</xsl:when>
    <xsl:when test="$service = 'admin-project-scripts-validate'">file-template</xsl:when>
    <xsl:when test="$service = 'project-admin-maintenance'">cog</xsl:when>
    <xsl:when test="$service = 'project-admin-config'">cog</xsl:when>
    <xsl:when test="$service = 'project-admin-dashboard'">dashboard</xsl:when>
    <xsl:when test="$service = 'project-admin-types'">file-template</xsl:when>
    <xsl:when test="$service = 'project-admin-types-validate'">file-template</xsl:when>
    <xsl:when test="$service = 'group-admin-dashboard'">dashboard</xsl:when>
    <xsl:when test="$service = 'group-admin-config'">cog</xsl:when>
    <xsl:when test="$service = 'group-admin-maintenance'">cog</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-publish'">logs</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-process'">logs</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-index'">logs</xsl:when>
    <xsl:when test="$service = 'group-admin-members'">member-groups</xsl:when>
    <xsl:when test="$service = 'group-admin-sharing'">cog</xsl:when>
    <xsl:when test="$service = 'account-drafts'">draft</xsl:when>
    <xsl:when test="$service = 'account-home'">home</xsl:when>
    <xsl:when test="$service = 'account-memberships'">member-groups</xsl:when>
    <xsl:when test="$service = 'account-personal'">member</xsl:when>
    <xsl:when test="$service = 'account-project-config'">member</xsl:when>
    <xsl:when test="$service = 'account-search'">search</xsl:when>
    <xsl:when test="$service = 'account-security'">member</xsl:when>
    <xsl:when test="$service = 'account-tasks'">task</xsl:when>
    <xsl:when test="$service = 'project-home'">project</xsl:when>
    <xsl:when test="$service = 'project-labels'">label</xsl:when>
    <xsl:when test="$service = 'project-members'">project</xsl:when>
    <xsl:when test="$service = 'project-search'">search</xsl:when>
    <xsl:when test="$service = 'group-home'">group</xsl:when>
    <xsl:when test="$service = 'group-tasks'">task</xsl:when>
    <xsl:when test="$service = 'group-activity'">system-status-o</xsl:when>
    <xsl:when test="$service = 'group-members'">group-member</xsl:when>
    <xsl:when test="$service = 'group-search'">search</xsl:when>
    <xsl:when test="$service = 'group-discussions'">discussion</xsl:when>
    <xsl:when test="$service = 'group-urls'">file-url</xsl:when>
    <xsl:when test="$service = 'folder-browse'">folder</xsl:when>
    <xsl:otherwise>file</xsl:otherwise>
  </xsl:choose>
</xsl:function>

<xsl:function name="f:service-title" as="xs:string?">
  <xsl:param name="service" as="xs:string"/>
  <xsl:choose>
    <xsl:when test="$service = 'admin-dashboard'">PageSeeder dashboard</xsl:when>
    <xsl:when test="$service = 'admin-logs-access'">Access logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-general'">General logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-index'">Index logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-mail'">Mail logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-process'">Process logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-publish'">Publish logs</xsl:when>
    <xsl:when test="$service = 'admin-logs-recent'">Recent logs</xsl:when>
    <xsl:when test="$service = 'admin-processes'">Admin processes</xsl:when>
    <xsl:when test="$service = 'admin-system'">System information</xsl:when>
    <xsl:when test="$service = 'admin-cache'">Cache information</xsl:when>
    <xsl:when test="$service = 'admin-indexing'">Server indexing</xsl:when>
    <xsl:when test="$service = 'admin-publisher'">Publisher status</xsl:when>
    <xsl:when test="$service = 'admin-administrators'">Administrators</xsl:when>
    <xsl:when test="$service = 'admin-members'">Members</xsl:when>
    <xsl:when test="$service = 'admin-members-import'">Import members</xsl:when>
    <xsl:when test="$service = 'admin-oauth-clients'">OAuth clients</xsl:when>
    <xsl:when test="$service = 'admin-oauth-access-tokens'">Access tokens</xsl:when>
    <xsl:when test="$service = 'admin-oauth-codes'">Authorization codes</xsl:when>
    <xsl:when test="$service = 'admin-oauth-refresh-tokens'">Refresh tokens</xsl:when>
    <xsl:when test="$service = 'admin-oauth-webhooks'">Webhooks</xsl:when>
    <xsl:when test="$service = 'admin-projects'">Groups &amp; projects</xsl:when>
    <xsl:when test="$service = 'admin-projects-archived'">Archived groups &amp; projects</xsl:when>
    <xsl:when test="$service = 'admin-projects-create'">Create a project</xsl:when>
    <xsl:when test="$service = 'admin-templates'">Project templates</xsl:when>
    <xsl:when test="$service = 'admin-files'">Default files</xsl:when>
    <xsl:when test="$service = 'admin-hosts'">Internal hosts</xsl:when>
    <xsl:when test="$service = 'admin-hosts'">External hosts</xsl:when>
    <xsl:when test="$service = 'admin-organization'">Organization customization</xsl:when>
    <xsl:when test="$service = 'admin-settings'">Server properties</xsl:when>
    <xsl:when test="$service = 'admin-license'">PageSeeder license</xsl:when>
    <xsl:when test="$service = 'admin-database'">Database settings</xsl:when>
    <xsl:when test="$service = 'admin-groups-create'">Create a group</xsl:when>
    <xsl:when test="$service = 'admin-project-files'">Project files</xsl:when>
    <xsl:when test="$service = 'admin-project-emails'">Email templates</xsl:when>
    <xsl:when test="$service = 'admin-project-catalog'">Indexing catalog</xsl:when>
    <xsl:when test="$service = 'admin-project-scripts'">Publish scripts</xsl:when>
    <xsl:when test="$service = 'admin-project-scripts-validate'">Validate publish scripts</xsl:when>
    <xsl:when test="$service = 'project-admin-maintenance'">Project maintenance</xsl:when>
    <xsl:when test="$service = 'project-admin-config'">Project configuration</xsl:when>
    <xsl:when test="$service = 'project-admin-dashboard'">Project dashboard</xsl:when>
    <xsl:when test="$service = 'project-admin-types'">Template configuration</xsl:when>
    <xsl:when test="$service = 'project-admin-types-validate'">Template validation</xsl:when>
    <xsl:when test="$service = 'group-admin-dashboard'">Group dashboard</xsl:when>
    <xsl:when test="$service = 'group-admin-config'">Group configuration</xsl:when>
    <xsl:when test="$service = 'group-admin-maintenance'">Group maintenance</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-publish'">Publish logs</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-process'">Process logs</xsl:when>
    <xsl:when test="$service = 'group-admin-logs-index'">Index logs for the group</xsl:when>
    <xsl:when test="$service = 'group-admin-members'">Project members</xsl:when>
    <xsl:when test="$service = 'group-admin-members'">Group members</xsl:when>
    <xsl:when test="$service = 'group-admin-sharing'">Group sharing</xsl:when>
    <xsl:when test="$service = 'account-drafts'">My drafts</xsl:when>
    <xsl:when test="$service = 'account-home'">Home</xsl:when>
    <xsl:when test="$service = 'account-memberships'">Groups and invitations</xsl:when>
    <xsl:when test="$service = 'account-personal'">Personal details</xsl:when>
    <xsl:when test="$service = 'account-project-config'">Personal publisher config</xsl:when>
    <xsl:when test="$service = 'account-search'">Global search</xsl:when>
    <xsl:when test="$service = 'account-security'">Security details and password</xsl:when>
    <xsl:when test="$service = 'account-tasks'">My tasks &amp; workflows</xsl:when>
    <xsl:when test="$service = 'project-home'">Project homepage</xsl:when>
    <xsl:when test="$service = 'project-labels'">Project labels</xsl:when>
    <xsl:when test="$service = 'project-members'">Project members</xsl:when>
    <xsl:when test="$service = 'project-search'">Project search</xsl:when>
    <xsl:when test="$service = 'group-home'">Group homepage</xsl:when>
    <xsl:when test="$service = 'group-tasks'">Group tasks</xsl:when>
    <xsl:when test="$service = 'group-activity'">Document activity</xsl:when>
    <xsl:when test="$service = 'group-members'">Group members</xsl:when>
    <xsl:when test="$service = 'group-search'">Group search</xsl:when>
    <xsl:when test="$service = 'group-discussions'">Group discussions</xsl:when>
    <xsl:when test="$service = 'account-urls'">Group URLs</xsl:when>
    <xsl:when test="$service = 'folder-browse'">Group documents</xsl:when>
    <xsl:otherwise></xsl:otherwise>
  </xsl:choose>
</xsl:function>

</xsl:stylesheet>
