<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-projects']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Projects &amp; groups')"/>
</xsl:template>

<xsl:template match="root[@service='admin-projects']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="group"/> Projects &amp; groups</h1>
    <admin-projects v-bind:initial-projects="{f:to-json-array(//project)}"
                    v-bind:initial-limit-reached="{//projects/@limitreached = 'true'}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
