<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-project-catalog']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Indexing catalog')"/>
</xsl:template>

<xsl:template match="root[@service='admin-project-catalog']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:variable name="project-template" select="//context/project/@template" />
    <xsl:variable name="catalog-name" select="//catalog/@name" />
    <h1 class="page-title"><svg-icon name="cog"/> Indexing catalog <xsl:value-of select="$catalog-name" /></h1>
    <xsl:if test="$project-template != $catalog-name">
      <callout-box type="warning">
        <p>
          By default groups under this project use the
          <a href="{$site-prefix}/ui/p/{$project-template}/admin/catalog.html">
            <b><xsl:value-of select="$project-template" /></b>
          </a>
          catalog.
        </p>
      </callout-box>
    </xsl:if>

    <xsl:variable name="catalog" select="//catalog"/>
    <table is="vue:basic-table">
      <thead>
        <tr>
          <th>Field name</th>
          <th>Stored</th>
          <th>Sorted</th>
          <th>Tokenized</th>
          <th>Numeric</th>
          <th>Date</th>
          <th>Boost</th>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="$catalog/field">
          <xsl:sort select="@name" />
          <tr>
            <td>
              <xsl:if test="@error='true'">
                <span title="This field is not always indexed with these settings."><svg-icon name="warning" color="auto" size="16"/>&#160;</span>
              </xsl:if>
              <xsl:value-of select="@name" />
              <xsl:if test="@error = 'true' and (starts-with(@name, 'psproperty-') or starts-with(@name, 'psmetadata-'))">
                <xsl:text>&#160;</xsl:text>
                <admin-catalog-search-link project="{$current-project}" fieldname="{@name}" />
              </xsl:if>
            </td>
            <td><svg-icon name="{if (@stored = 'true') then 'ok' else 'cross'}" color="{if (@stored = 'true') then 'auto' else 'grey'}" size="16"/></td>
            <td><xsl:choose>
              <xsl:when test="@doc-values = 'sorted-set'"><svg-icon name="ok" color="auto" size="16"/><span title="sorted with multiple values">*</span></xsl:when>
              <xsl:when test="@doc-values = 'sorted'"><svg-icon name="ok" color="auto" size="16"/></xsl:when>
              <xsl:otherwise><svg-icon name="cross" color="grey" size="16"/></xsl:otherwise>
            </xsl:choose></td>
            <td><svg-icon name="{if (@tokenized = 'true') then 'ok' else 'cross'}" color="{if (@tokenized = 'true') then 'auto' else 'grey'}" size="16"/></td>
            <td><xsl:value-of select="@numeric-type" /></td>
            <td><xsl:value-of select="@date-format" /><xsl:if test="@date-resolution"><br/><xsl:value-of select="@date-resolution" /></xsl:if></td>
            <td><xsl:value-of select="@boost" /></td>
          </tr>
        </xsl:for-each>
        <xsl:if test="not($catalog/field)">
          <tr>
            <td colspan="7">
              <i>The catalog is empty probably because the group indexes are still empty.</i>
            </td>
          </tr>
        </xsl:if>
      </tbody>
    </table>

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
