<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-hosts']" mode="html-title" as="xs:string*">
  <xsl:variable name="external" select="//parameter[@name='external'] = 'true'"/>
  <xsl:sequence select="(if ($external) then 'External hosts' else 'Internal hosts')"/>
</xsl:template>

<xsl:template match="root[@service='admin-hosts']" mode="main-content">
<div class="main-content">
  <xsl:variable name="external" select="//parameter[@name='external'] = 'true'"/>
  <xsl:variable name="by-name" select="function($i) { $i ! $i/@name }" as="function(*)"/>
  <main-panel>
    <h1 class="page-title">
      <svg-icon name="cog"/><xsl:text> </xsl:text><xsl:value-of select="if ($external) then 'External' else 'Internal'"/> hosts</h1>
    <admin-hosts v-bind:initial-hosts="{f:to-json-array(sort(content/hosts/host, (), $by-name))}">
      <xsl:if test="$external"><xsl:attribute name="external"/></xsl:if>
      <xsl:if test="content/hosts/@limitreached = 'true'"><xsl:attribute name="has-more"/></xsl:if>
    </admin-hosts>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
