<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-groups-create']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Create group')"/>
</xsl:template>

<xsl:template match="root[@service='admin-groups-create']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Create a new group</h1>
    <xsl:variable name="website-address" select="//constants/@website-address"/>
    <xsl:variable name="emaildomain" select="if (//constants/@email-domain = 'pshosts') then content/context/defaulthost else //constants/@email-domain"/>
    <group-creation default-owner="{//context/project/@owner}"
                    email-domain="{$emaildomain}"
                    parent-project="{//context/project/@name}"
                    parent-project-template="{//context/project/@template}"
                    v-bind:properties="{f:to-json-group-properties(content/properties)}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
