<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-database']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Database settings')"/>
</xsl:template>

<xsl:template match="root[@service='admin-database']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Database settings</h1>
    <xsl:variable name="setup" select="content/setup"/>
    <database-form
                initial-database-name="{$setup/dbname}"
                initial-database-type="{$setup/dbtype}"
                initial-database-url="{$setup/dburl}"
                initial-hostname="{$setup/dbhostname}"
                initial-login-name="{$setup/dbloginname}"
                database-url-default="{$setup/dburldefault}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
