<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-dashboard']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Administration dashboard')"/>
</xsl:template>

<xsl:template match="root[@service='admin-dashboard']" mode="main-content">
<div class="main-content">
  <main-panel>

    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="dashboard"/> PageSeeder dashboard</h1>

    <!-- General alerts -->
    <xsl:if test="//constants/@license-expires != ''">
      <xsl:variable name="days-left" select="days-from-duration(xs:date(//constants/@license-expires) - current-date())"/>
      <xsl:if test="$days-left lt 21">
        <callout-box type="warning">
          <p>The PageSeeder license will expire in <b><xsl:value-of select="$days-left" /></b> days,
            when most admin pages and all email notifications will be disabled.
            <a href="{$site-prefix}/ui/admin/license.html" class="button small float-right warning">PageSeeder license</a>
          </p>
        </callout-box>
      </xsl:if>
    </xsl:if>

    <xsl:if test="not(//context/properties/property[@name='disableIndexing' and @value='true'])">
      <xsl:if test="//about-index/groups[@obsolete != '0']">
        <callout-box type="warning">
          <p>There is <b><xsl:value-of select="//about-index/groups/@obsolete" /></b> group<xsl:value-of select="if (//about-index/groups/@obsolete = '1') then '' else 's'" />
            with an obsolete index that MUST be re-indexed.
            <a href="{$site-prefix}/ui/admin/indexing.html" class="button small float-right warning">Indexing</a>
          </p>
        </callout-box>
      </xsl:if>
      <xsl:if test="//about-index/groups[@old != '0']">
        <callout-box type="warning">
          <p>There is <b><xsl:value-of select="//about-index/groups/@old" /></b> group<xsl:value-of select="if (//about-index/groups/@old = '1') then '' else 's'" />
            with an old index that SHOULD be re-indexed.
            <a href="{$site-prefix}/ui/admin/indexing.html" class="button small float-right warning">Indexing</a>
          </p>
        </callout-box>
      </xsl:if>
    </xsl:if>

    <xsl:if test="//check-host[@status = 'not-found']">
      <callout-box type="warning">
        <p>The host <b><xsl:value-of select="//resolved-host" /></b> in the URL is not registered in PageSeeder.
          If this is a clone of another server the previous internal host may need to be edited.
          <a href="{$site-prefix}/ui/admin/hosts.html" class="button small float-right warning">Internal hosts</a>
        </p>
      </callout-box>
    </xsl:if>

    <xsl:if test="//ui[@disabled = 'true']">
      <callout-box type="warning">
        <p>Organization customization is disabled, because license type is not "Developer" or "Service provider".
          <a href="{$site-prefix}/ui/admin/license.html" class="button small float-right warning">PageSeeder license</a>
        </p>
      </callout-box>
    </xsl:if>

    <xsl:if test="//ui[@error = 'true']">
      <callout-box type="error">
        <p>There was an error loading the organization customization, see general logs for details.
          <a href="{$site-prefix}/ui/admin/logs/general.html" class="button small float-right error">General logs</a>
        </p>
      </callout-box>
    </xsl:if>

    <xsl:variable name="warnings" select="count(//webhook[@status = 'warning'])"/>
    <xsl:variable name="errors"   select="count(//webhook[@status = 'error' or @status = 'unreachable']) + (if (//webhooks/@cache-error = 'true') then 1 else 0)"/>
    <xsl:choose>
      <xsl:when test="$errors gt 0">
        <callout-box type="error">
          <p>There is <b><xsl:value-of select="$errors" /></b> webhook error<xsl:value-of select="if ($errors = 1) then '' else 's'" />.
            <a href="{$site-prefix}/ui/admin/oauth/webhooks.html" class="button small float-right alert">Webhooks</a>
          </p>
        </callout-box>
      </xsl:when>
      <xsl:when test="$warnings gt 0">
        <callout-box type="error">
          <p>There is <b><xsl:value-of select="$warnings" /></b> webhook warning<xsl:value-of select="if ($warnings = 1) then '' else 's'" />.
            <a href="{$site-prefix}/ui/admin/oauth/webhooks.html" class="button small float-right warning">Webhooks</a>
          </p>
        </callout-box>
      </xsl:when>
    </xsl:choose>

    <xsl:if test="//schedule/event[status = 'error']">
      <callout-box type="error">
        <p>There are errors on scheduled publish events.
          <a href="{$site-prefix}/ui/admin/publisher.html" class="button small float-right alert">Publisher</a>
        </p>
      </callout-box>
    </xsl:if>

    <xsl:variable name="hprof-files">
      <xsl:for-each select="//alerts/file">
        <xsl:sort select="@modified" />
        <xsl:sequence select="."/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:if test="$hprof-files//file">
      <xsl:variable name="lastone" select="($hprof-files//file)[last()]" />
      <callout-box type="error">
        <p>PageSeeder has experienced an out of memory error on
          <b><time datetime="{$lastone/@modified}">
            <xsl:value-of select="format-dateTime(xs:dateTime($lastone/@modified), '[D] [MNn] [Y] at [H01]:[m01]')" />
          </time></b>
          and the file <b><xsl:value-of select="$lastone/@fullpath" /></b> should be moved to another location for analysis or deleted.
          PageSeeder should also be restarted if it hasn't already been restarted since the error.</p>
      </callout-box>
    </xsl:if>

    <xsl:if test="//alerts[@outgoing-email-disabled = 'true']">
      <callout-box type="warning">
        <p>
          Outgoing email is disabled on this server. To enable it configure email settings.
          <a href="{$site-prefix}/ui/admin/email.html" class="button small float-right warning">Email settings</a>
        </p>
      </callout-box>
    </xsl:if>

    <xsl:if test="//alerts[@incoming-email-disabled-message]">
      <callout-box type="warning">
        <p>
          Incoming email is disabled on this server. See email settings for details.
          <a href="{$site-prefix}/ui/admin/email.html" class="button small float-right warning">Email settings</a>
        </p>
      </callout-box>
    </xsl:if>

    <server-message-form current-message="{//server-message}"/>

    <xsl:variable name="disk-space">
      <json:map>
        <json:number key="usable"><xsl:value-of select="//disk-space/@usable"/></json:number>
        <json:number key="total"><xsl:value-of select="//disk-space/@total"/></json:number>
      </json:map>
    </xsl:variable>
    <xsl:variable name="memory">
      <json:map>
        <json:number key="free"><xsl:value-of select="//memory/@free"/></json:number>
        <json:number key="total"><xsl:value-of select="//memory/@total"/></json:number>
        <json:number key="max"><xsl:value-of select="//memory/@max"/></json:number>
      </json:map>
    </xsl:variable>

    <dashboard-status v-bind:disk-space="{json:xml-to-json($disk-space)}"
                      v-bind:memory="{json:xml-to-json($memory)}" />

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
