<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-cache']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Cache overview')"/>
</xsl:template>

<xsl:template match="root[@service='admin-cache']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="system-status"/> Cache overview</h1>
    <xsl:apply-templates select="content" mode="admin-cache"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

<xsl:template match="content[@name='get-caching-overview']" mode="admin-cache">
  <cache-overview-table v-bind:caches="{f:to-json-cache-map(descendant::cache)}" />
</xsl:template>

<xsl:function name="f:to-json-cache-map" as="xs:string">
  <xsl:param name="caches" as="element()*"/>
  <xsl:variable name="map">
    <json:map>
      <xsl:for-each select="$caches">
        <xsl:sort select="@name"/>
        <json:map key="{@name}">
          <json:string key="name"><xsl:value-of select="@name"/></json:string>
          <json:string key="guid"><xsl:value-of select="@guid"/></json:string>
          <json:string key="status"><xsl:value-of select="@status"/></json:string>
          <json:boolean key="disabled"><xsl:value-of select="@disabled = 'true'"/></json:boolean>
          <json:number key="size"><xsl:value-of select="info/@size"/></json:number>
        </json:map>
      </xsl:for-each>
    </json:map>
  </xsl:variable>
  <xsl:value-of select="json:xml-to-json($map)"/>
</xsl:function>

<xsl:function name="f:to-json-cache" as="xs:string">
  <xsl:param name="cache" as="element()"/>
  <xsl:variable name="map">
    <json:map>
      <json:string key="name"><xsl:value-of select="$cache/@name"/></json:string>
      <json:string key="guid"><xsl:value-of select="$cache/@guid"/></json:string>
      <json:string key="status"><xsl:value-of select="$cache/@status"/></json:string>
      <json:boolean key="disabled"><xsl:value-of select="$cache/@disabled = 'true'"/></json:boolean>
      <xsl:if test="$cache/info">
        <json:number key="size"><xsl:value-of select="$cache/info/@size"/></json:number>
      </xsl:if>
    </json:map>
  </xsl:variable>
  <xsl:value-of select="json:xml-to-json($map)"/>
</xsl:function>

</xsl:stylesheet>
