<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-personal']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Personal details')"/>
</xsl:template>

<xsl:template match="root[@service='account-personal']" mode="main-content">
<div class="main-content">
  <xsl:variable name="max-attachment-size" select="//constants/@max-attachment-size"/>
  <main-panel>
    <div class="grid-x grid-margin-x align-center">
      <div class="cell medium-9">
        <h1 class="page-title"><svg-icon name="member"/> Personal details</h1>
        <account-personal-form v-bind:max-attachment-size="{$max-attachment-size}" />
      </div>
    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
