<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-drafts']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Drafts')"/>
</xsl:template>

<xsl:template match="root[@service='account-drafts']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">

      <h1 class="page-title"><svg-icon name="draft"/> My drafts</h1>

      <xsl:variable name="drafts"   select="//comments/comment|//drafts/draft"/>
      <xsl:variable name="has-more" select="//comments/@limitreached = 'true' or //drafts/@limitreached = 'true'"/>
      <xsl:variable name="groups"   select="//projects/group"/>

      <xsl:choose>
        <xsl:when test="empty($drafts)">
          <callout-box type="info">
            <p>You have no drafts.</p>
          </callout-box>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="json-drafts">
            <json:array>
              <xsl:apply-templates select="$drafts" mode="json-draft">
                <xsl:sort select="if (modifiedby/@date) then modifiedby/@date else @created" order="descending"/>
                <xsl:with-param name="groups" select="$groups"/>
              </xsl:apply-templates>
            </json:array>
          </xsl:variable>
          <account-drafts v-bind:drafts="{f:xml-to-json($json-drafts)}">
            <xsl:if test="$has-more"><xsl:attribute name="has-more" /></xsl:if>
          </account-drafts>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

<xsl:template match="comment" mode="json-draft">
  <xsl:param name="groups"/>
  <xsl:variable name="my-group" select="if (group) then group[1] else context/group"/>
  <xsl:variable name="group" select="$groups[@id = $my-group[1]/@id]"/>
  <xsl:variable name="archived-group" select="starts-with($my-group/@name, 'archive-') or starts-with(context/uri/@path, concat($site-prefix, '/archive/'))" />
  <json:map>
    <json:string key="is"><xsl:value-of select="if (@contentrole = 'Workflow') then 'workflow' else if (@status) then 'task' else 'comment'" /></json:string>
    <json:number key="id"><xsl:value-of select="@discussionid"/></json:number>
    <json:string key="date"><xsl:value-of select="if (modifiedby/@date) then modifiedby/@date else @created" /></json:string>
    <xsl:if test="@id != @discussionid"><json:boolean key="isReply">true</json:boolean></xsl:if>
    <xsl:if test="$archived-group"><json:boolean key="groupArchived">true</json:boolean></xsl:if>
    <xsl:if test="empty($group)"><json:boolean key="groupRemoved">true</json:boolean></xsl:if>
    <json:map key="group">
      <json:string key="name"><xsl:value-of select="if ($group) then $group/@name else group[1]/@name" /></json:string>
      <json:string key="title"><xsl:value-of select="if ($group) then $group/@title else group[1]/@name" /></json:string>
    </json:map>
    <xsl:if test="count(group) gt 1">
      <json:array key="groups">
        <xsl:for-each select="group">
          <json:map>
            <json:string key="name"><xsl:value-of select="@name" /></json:string>
            <json:string key="title"><xsl:value-of select="@title" /></json:string>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:if test="context/uri">
      <json:map key="context">
        <json:string key="title"><xsl:value-of select="context/uri/displaytitle" /></json:string>
        <json:number key="id"><xsl:value-of select="context/uri/@id" /></json:number>
      </json:map>
    </xsl:if>
    <json:string key="title"><xsl:value-of select="if (title != '') then title else '[untitled]'" /></json:string>
    <json:string key="extract"><xsl:value-of select="substring(content, 1, 100)" /></json:string>
  </json:map>
</xsl:template>

<xsl:template match="draft" mode="json-draft">
  <xsl:param name="groups"/>
  <xsl:variable name="group" select="$groups[@id = current()/group[1]/@id]"/>
  <xsl:variable name="archived-group" select="starts-with(context/uri/@path, concat($site-prefix, '/archive/'))" />
  <json:map>
    <json:string key="is">edit</json:string>
    <json:number key="id"><xsl:value-of select="@id"/></json:number>
    <json:string key="date"><xsl:value-of select="@created" /></json:string>
    <xsl:if test="$archived-group"><json:boolean key="groupArchived">true</json:boolean></xsl:if>
    <xsl:if test="empty($group)"><json:boolean key="groupRemoved">true</json:boolean></xsl:if>
    <json:map key="group">
      <json:string key="name"><xsl:value-of select="if ($group) then $group/@name else group[1]/@name" /></json:string>
      <json:string key="title"><xsl:value-of select="if ($group) then $group/@title else group[1]/@name" /></json:string>
    </json:map>
    <xsl:if test="count(group) gt 1">
      <json:array key="groups">
        <xsl:for-each select="group">
          <json:map>
            <json:string key="name"><xsl:value-of select="@name" /></json:string>
            <json:string key="title"><xsl:value-of select="@title" /></json:string>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <json:string key="fragment"><xsl:value-of select="context/@fragment" /></json:string>
    <xsl:apply-templates select="context/uri" mode="json">
      <xsl:with-param name="key">uri</xsl:with-param>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

</xsl:stylesheet>
