<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd

  Structural elements - template may be used when displaying PSML documents in contexts other than document view
  or preview.
-->
<xsl:stylesheet version="3.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                xmlns:diff="https://www.pageseeder.org/diffx"
                xmlns:track="https://www.pageseeder.org/diffx/track"
                xmlns:psml="http://pageseeder.com/PSML"
                exclude-result-prefixes="#all">

<!-- Element `<document>` maps to `<article>` -->
<xsl:template match="document" mode="psml">
  <article class="psml-document">
    <xsl:apply-templates select="@type" mode="psml-data"/>
    <xsl:apply-templates mode="#current"/>
  </article>
</xsl:template>

<!-- Element `<section>` maps to `<section>` tag -->
<xsl:template match="section" mode="psml">
  <section id="section-{@id}" class="psml-section">
    <xsl:apply-templates mode="#current"/>
  </section>
</xsl:template>

<!-- Element `<title>` used for section titles -->
<xsl:template match="title" mode="psml">
  <h2 class="title">
    <xsl:apply-templates mode="#current"/>
  </h2>
</xsl:template>

<!--
  Element `<fragment>` (default fragment) with PSML content  maps to `<div>`
-->
<xsl:template match="fragment" mode="psml">
  <div>
    <xsl:call-template name="psml-fragment-attributes"/>
    <div class="psml-content">
      <xsl:apply-templates mode="#current"/>
    </div>
  </div>
</xsl:template>

<!--
  Element `<media-fragment>`
-->
<xsl:template match="media-fragment" mode="psml">
  <div>
    <xsl:call-template name="psml-fragment-attributes"/>
    <xsl:choose>
      <xsl:when test="diff:ins|diff:del|track:ins|track:del|track:span">
        <xsl:variable name="diff"><xsl:apply-templates select="*|text()" mode="psml"/></xsl:variable>
        <psml-media mediatype="{@mediatype}" content="{serialize($diff)}">
          <xsl:if test="parent::diff or @track:id"><xsl:attribute name="diff"/></xsl:if>
        </psml-media>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="content" select="psml:serialize-media-content(*|text(), @mediatype)"/>
        <psml-media mediatype="{@mediatype}" content="{$content}">
          <xsl:if test="parent::diff or @track:id"><xsl:attribute name="diff"/></xsl:if>
        </psml-media>
      </xsl:otherwise>
    </xsl:choose>
  </div>
</xsl:template>

<!-- Element `<properties-fragment>` use component -->
<xsl:template match="properties-fragment" mode="psml">
  <div>
    <xsl:call-template name="psml-fragment-attributes"/>
    <xsl:variable name="properties">
      <json:array key="properties">
        <xsl:apply-templates select="property" mode="json-document"/>
      </json:array>
    </xsl:variable>
    <psml-properties group-name="{$current-group}"
                     v-bind:properties="{json:xml-to-json($properties)}">
    </psml-properties>
  </div>
</xsl:template>

<!-- Element `<properties>` (metadata on default fragment) -->
<xsl:template match="properties" mode="psml">
  <xsl:variable name="properties">
    <json:array>
      <xsl:apply-templates select="property" mode="json-document"/>
    </json:array>
  </xsl:variable>
  <psml-properties group-name="{$current-group}"
                   v-bind:properties="{json:xml-to-json($properties)}">
  </psml-properties>
</xsl:template>

<!-- Element `<xref-fragment>` with PSML content -->
<xsl:template match="xref-fragment" mode="psml">
  <div>
    <xsl:call-template name="psml-fragment-attributes"/>
    <xsl:variable name="xrefs">
      <json:array key="xrefs">
        <xsl:apply-templates select="xref|blockxref" mode="json-document"/>
      </json:array>
    </xsl:variable>
    <psml-xref-list group-name="{$current-group}"
                    v-bind:xrefs="{json:xml-to-json($xrefs)}" />
  </div>
</xsl:template>

<!--
  Common attributes for fragments
-->
<xsl:template name="psml-fragment-attributes">
  <xsl:attribute name="id" select="concat('fragment-', @id)"/>
  <xsl:attribute name="class" select="'psml-fragment'"/>
  <xsl:attribute name="data-fragment" select="@id"/>
  <xsl:attribute name="data-psml" select="name()"/>
  <xsl:if test="@type">
    <xsl:attribute name="data-type" select="@type"/>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>