<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd

  Simply converts PSML to a string.
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">
<!--
  Serialize as XML with indentation of structural and block-level elements.
-->
<xsl:template match="*|text()" mode="psml-source" priority="2">
  <xsl:variable name="serialization-parameters" as="element()">
    <output:serialization-parameters xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization">
      <output:method value="xml"/>
      <output:indent value="yes"/>
      <!-- We don't indent elements that may contain mixed content -->
      <output:suppress-indentation value="media-fragment block caption cell heading hcell item para preformat"/>
    </output:serialization-parameters>
  </xsl:variable>
  <!-- The serialize function inserts newlines at the start and end. We don't want them. -->
  <xsl:value-of select="replace(serialize(., $serialization-parameters), '(^\n|\n$)', '')"/>
</xsl:template>

</xsl:stylesheet>