<?xml version="1.0"?>
<!--
  Template used when a URL is created or edited

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='new-uri']" mode="meta">
  <meta name="list-id"            content="{group/@name}.{$emaildomain}" />
  <meta name="list-name"          content="{group/@description}" />
  <meta name="list-help"          content="{$linksprefix}/home?group={group/@name}" />
  <meta name="list-unsubscribe"      content="{$linksprefix}/unsubscribe?group={group/@name}&amp;{if
    (@announcement = 'true') then 'deregister=true' else 'notification=none'}&amp;token={@unsubscribetoken}" />
  <meta name="list-unsubscribe-post" content="List-Unsubscribe=One-Click" />
  <meta name="list-post"          content="{$linksprefix}/newcomment?group={group/@name}" />
  <meta name="list-archive"       content="{$linksprefix}/comments?group={group/@name}" />
  <title>
    <xsl:text>[</xsl:text>
    <xsl:value-of select="group/@name" />
    <xsl:text>] </xsl:text>
    <xsl:value-of select="message/title" />
  </title>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='new-uri']" mode="body">
  <!-- Broadcast All -->
  <xsl:if test="@announcement = 'true'">
    <table class="announcement"><tr><td>This email has been sent to you regardless of your
    <xsl:value-of select="$appname" /> notification settings because it is an announcement.</td></tr></table>
  </xsl:if>

  <!-- Contents -->
  <xsl:copy-of select="message/content[@type = 'application/xhtml+xml']/node()" />

  <!-- Labels -->
  <xsl:apply-templates select="message" mode="labels" />

  <!-- Attachments -->
  <xsl:apply-templates select="message" mode="attachments" />
</xsl:template>

<!-- ====================================================================== -->
<!-- Supporting templates -->
<!-- ====================================================================== -->


<xsl:template match="message" mode="labels">
  <xsl:if test="labels">
    <xsl:sequence select="f:labels($images-url, labels)"/>
  </xsl:if>
</xsl:template>

<xsl:template match="message" mode="attachments">
<xsl:if test="attachment/uri">
  <h4 class="subtitle">
    <xsl:choose>
      <xsl:when test="@contentrole='File Upload'">Uploaded documents</xsl:when>
      <xsl:when test="@contentrole='File Creation'">Created document</xsl:when>
      <xsl:when test="@contentrole='URL Creation'">Created URL</xsl:when>
      <xsl:otherwise>Modified URL</xsl:otherwise>
    </xsl:choose>
  </h4>
  <table width="100%" cellpadding="2" cellspacing="0" border="0" style="border-collapse: collapse"><tbody>
    <xsl:for-each select="attachment/uri">
      <tr>
        <td style="width:20px;font-size:13px;"><img src="{$images-url}/{f:mediatype-icon(.)}"  class="is-icon" width="20" border="0" alt="" /></td>
        <xsl:variable name="view"     select="concat($linksprefix, '/uri?group=', ../../../group/@name, '&amp;uri=', @id)" />
        <xsl:variable name="download" select="concat($linksprefix, '/download?uri=', @id)" />
        <td style="font-size: 13px;"><xsl:sequence select="f:link($view, displaytitle)" /></td>
        <td style="font-size: 13px;text-align:right">
          <xsl:if test="not(@mediatype = 'folder')">
            <xsl:sequence select="f:link($download, 'Download')" />
          </xsl:if>
        </td>
      </tr>
    </xsl:for-each>
  </tbody></table>
</xsl:if>
</xsl:template>

</xsl:stylesheet>
