<?xml version="1.0"?>
<!--
  Template used when a membership has been accepted

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='membership-complete']" mode="meta">
  <title>[<xsl:value-of select="membership/(group|project)/@name" />] <xsl:value-of select=" if (membership/project) then 'Project' else 'Group'"/> registration</title>
</xsl:template>

<!-- Banner -->
<xsl:template match="notification[@template='membership-complete']" mode="banner">
  <p wrapper-class="membership-wrap"><xsl:value-of select="$appname" /> group registration</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='membership-complete']" mode="body">
  <!-- compute the help URL -->
  <xsl:variable name="helpurl" select="if (string(/notification/organization/application/@helppage) != '')
                                then /notification/organization/application/@helppage
                                else 'https://user.pageseeder.com'"/>
  <xsl:variable name="project-group" select="if (membership/group) then 'group ' else 'project '"/>

  <h3>Hi <xsl:value-of select="membership/member/@firstname" />,</h3>

  <xsl:choose>
    <xsl:when test="inviter">
      <p class="lead"><b><xsl:value-of select="inviter/fullname"/></b> has added you to <xsl:value-of select="$project-group"/><b><xsl:value-of select="membership/(group|project)/@name" /></b>.</p>
    </xsl:when>
    <xsl:otherwise>
      <p class="lead">You have now joined <xsl:value-of select="$project-group"/><b><xsl:value-of select="membership/(group|project)/@name" /></b>.</p>
    </xsl:otherwise>
  </xsl:choose>

  <!-- Copy the welcome message -->
  <xsl:if test="membership/(group|project)/message">
    <p><xsl:copy-of select="f:text-to-html(membership/(group|project)/message)" /></p>
  </xsl:if>

  <xsl:variable name="email-address" select="concat(membership/(group|project)/@name, '@', $emaildomain)" />

  <xsl:call-template name="table">
    <xsl:with-param name="title-image">ico-group.png</xsl:with-param>
    <xsl:with-param name="title"><xsl:value-of select="membership/(group|project)/@name" /></xsl:with-param>
    <xsl:with-param name="rows">
      <rows xmlns="">
        <row title="{if (membership/project) then 'Project' else 'Group'} title"><xsl:value-of select="f:group-title(membership/(group|project))" /></row>
        <row title="Description"><xsl:value-of select="membership/(group|project)/@description" /></row>
        <row title="Notification"><xsl:value-of select="f:notification(membership/@notification)" /></row>
        <xsl:choose>
          <xsl:when test="membership/(group|project)/@homeurl">
            <row title="Home">
              <xsl:sequence select="f:link(membership/(group|project)/@homeurl, membership/(group|project)/@homeurl)" />
            </row>
          </xsl:when>
          <xsl:otherwise>
            <row title="Home">
              <xsl:sequence select="f:link(concat($linksprefix, '/home?group=', membership/(group|project)/@name),
                                           concat($linksprefix, '/home?group=', membership/(group|project)/@name))" />
            </row>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="@generalcomments = 'true' and $email-address">
          <row title="Email">
            <xsl:sequence select="f:link(concat('mailto:', $email-address), $email-address)" />
          </row>
        </xsl:if>
      </rows>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:if test="@generalcomments = 'true' and $email-address">
    <h4>What's next?</h4>
    <p>You can send a message to this <xsl:value-of select="$project-group"/>by posting to
    <xsl:sequence select="f:link(concat('mailto:', $email-address), $email-address)" />.</p>
  </xsl:if>

  <h4>Read me first</h4>
  <p>The system powering this <xsl:value-of select="$project-group"/>is called <xsl:value-of select="$appname" />.<br/>
  If you are unfamiliar with <xsl:value-of select="$appname" /> please follow the link below for an introduction to its features.</p>
  <p><a href="{$helpurl}"><xsl:value-of select="$helpurl" /></a></p>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='membership-complete']" mode="footer">
  <xsl:call-template name="noreply"/>
  <xsl:variable name="group" select="membership/(group|project)"/>
  <p>You received this message because you are part of the <i><xsl:value-of select="$group/@name" /></i>
   group on <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.</p>
  <p>Manage your ongoing  notification settings using your <a href="{$linksprefix}/mygroups">group options</a>
    or <a href="{$linksprefix}/unsubscribe?group={$group/@name}&amp;token={@unsubscribetoken}">unsubscribe</a> from this group.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
