<?xml version="1.0"?>
<!--
  Auto responder email

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='auto-responder']" mode="meta">
  <title>WARNING: Comment limit reached</title>
</xsl:template>

<!-- Banner across the top -->
<xsl:template match="notification[@template='auto-responder']" mode="banner">
  <p wrapper-class="alert-wrap"><xsl:value-of select="$appname" /> warning</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='auto-responder']" mode="body">
  <table class="warning"><tr><td>The location this comment was sent to has almost reached
  the maximum allowed within <xsl:value-of select="autoresponder/@minutes" /> minutes.
  See <a href="https://dev.pageseeder.com/guide/configuration/emails/incoming_emails.html">comment limits</a>
  for more details.</td></tr></table>

  <p>Please wait <b><xsl:value-of select="autoresponder/@minutes" /></b> minutes before
  submitting any more comments to this location.</p>

  <xsl:call-template name="message">
    <xsl:with-param name="subject" select="comment/title" />
    <xsl:with-param name="author"  select="comment/author" />
    <xsl:with-param name="content" select="comment/content[contains(@type,'text/plain')]" />
    <xsl:with-param name="uri"     select="comment/context/uri" />
  </xsl:call-template>

  <!-- More info -->
  <xsl:variable name="link" select="if (comment/context/group)
        then concat($linksprefix, '/comments?group=', comment/context/group/@name)
        else concat($linksprefix, '/uri?uri=', comment/context/uri/@id,
           if (comment/context/@fragment) then concat('&amp;fragment=',encode-for-uri(comment/context/@fragment)) else '')"/>
  <p>View this comment in <a href="{$link}">context</a>.</p>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='auto-responder']" mode="footer">
  <xsl:call-template name="noreply"/>
  <p>You received this message because the email address <i><xsl:value-of select="comment/author/@email"/></i> was used to
  post a message on <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)" /></a>.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
