<?xml version="1.0"?>
<!--
  This schematron identifies documents that have XRefs or images which are unresolved or point to archived documents.
  @version 5.9910
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <sch:title>Validate References</sch:title>

  <!--
    Set of rules applying to the document
  -->
  <sch:pattern name="document">

    <!-- Match document -->
    <sch:rule context="document">

      <!-- An image should be referenced by at least one document -->
      <sch:assert id="NOT_REFERENCED" test="not(starts-with(documentinfo/uri/@mediatype,'image/') and not(//reversexref))">
        This image is not referenced by any documents.
      </sch:assert>

      <!-- An image shouldn't only be referenced by archived documents -->
      <sch:assert id="REFERENCED_BY_ARCHIVE" test="not(starts-with(documentinfo/uri/@mediatype,'image/') and //reversexref and not(//reversexref[not(contains(@href,'/archive/'))]))">
        This image is only referenced by archived documents.
      </sch:assert>

    </sch:rule>

  </sch:pattern>

  <!--
    Set of rules applying to the XRefs
  -->
  <sch:pattern name="XRefs">

    <!-- Match cross references -->
    <sch:rule context="(xref[not(@external='true')]|blockxref)[not(ancestor::media-fragment)]">

      <sch:let name="locator" value="//locator[@fragment = current()/ancestor::fragment/@id]" />

      <!-- Cross references should not point to archived documents -->
      <sch:assert id="XREF_ARCHIVED" test="not(@archived='true')"
                  properties="fragment" flag="warning"
      >Cross-reference &#x201C;<sch:value-of select="text()"/>&#x201D; points to
        <sch:value-of select="if (starts-with(@href,'/ps/archive/'))
          then 'a document in an archived group' else 'an archived document'"/>.</sch:assert>

      <!-- Cross references should resolve to an actual document -->
      <sch:assert id="XREF_UNRESOLVED" test="not(@unresolved = 'true')"
                  properties="fragment" flag="error"
      >Cross-reference &#x201C;<sch:value-of select="text()"/>&#x201D; is unresolved.</sch:assert>

      <!-- Transculsion containing transclusion not supported -->
      <sch:assert id="XREF_TRANSCLUDE_NESTED"
                  test="not(@type='transclude' and (/document/documentinfo | $locator)//reversexref[@forwardtype='transclude'])"
                  properties="fragment" flag="warning"
      >Content containg transclusion &#x201C;<sch:value-of select="@urititle"/>&#x201D;
        is being transcluded (nested transclusions are not supported).</sch:assert>

    </sch:rule>

    <!-- Match reverse cross references -->
    <sch:rule context="(reversexref)[not(ancestor::media-fragment)]">

      <!-- Reverse cross references should not be from an archived documents -->
      <sch:assert id="REVERSEXREF_ARCHIVED" test="not(@archived='true')"
                  properties="fragment" flag="warning"
      >Incoming reference from archived document &#x201C;<sch:value-of select="@urititle"/>&#x201D;.</sch:assert>

    </sch:rule>

  </sch:pattern>

  <!--
    Set of rules applying to the images
  -->
  <sch:pattern name="Images">

    <!-- Match image reference -->
    <sch:rule context="image[not(ancestor::media-fragment)]">

      <!-- Image references should not point to archived files -->
      <sch:assert id="IMAGE_ARCHIVED" test="not(contains(@src, '/archive/'))"
                  properties="fragment" flag="warning">An image should not point to
        <sch:value-of select="if (starts-with(@src,'/ps/archive/'))
          then 'a document in an archived group: ' else 'an archived document: '"/>
        <sch:value-of select="tokenize(@src,'/')[last()]"/>.</sch:assert>

      <!-- Image references should resolve to an actual image file -->
      <sch:assert id="IMAGE_UNRESOLVED" test="not(@unresolved = 'true') and @uriid"
                  flag="error" properties="fragment">Document contains an unresolved
        image.</sch:assert>

    </sch:rule>

  </sch:pattern>

  <sch:pattern name="Links">
    <sch:title>Check links and xrefs to external URLs</sch:title>

    <sch:rule context="(link|xref[@external='true'])[not(ancestor::media-fragment or starts-with(@href,'mailto:'))]">

      <sch:let name="url-metadata"
               value="document(concat('ps:source-metadata?method=head&amp;url=',
                      encode-for-uri(@href)))"/>

      <!-- Broken links -->
      <sch:assert test="$url-metadata/url-source-metadata[@status='ok' or @status='requires_authentication' or @status='redirect']"
                  id="BROKEN_LINK" properties="fragment" flag="error"
      ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; is broken:
        unable to access &#x201C;<sch:value-of select="@href"/>&#x201D;.</sch:assert>

      <!-- Broken links -->
      <sch:assert test="not(@archived='true')"
                  id="ARCHIVED_LINK" properties="fragment" flag="warning"
      ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; points to
        an archived URL: &#x201C;<sch:value-of select="@href"/>&#x201D;.</sch:assert>

      <!-- Redirects -->
      <sch:assert test="not(starts-with(@href, 'http://'))"
                  id="UNSECURE_REDIRECT" properties="fragment" flag="warning"
      ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; points to an unsecure site.</sch:assert>

      <!-- Redirects -->
      <sch:report test="starts-with(@href, 'https://') and $url-metadata/url-source-metadata[@status='redirect']"
                  id="REDIRECT" properties="fragment" flag="info"
      ><sch:value-of select="name()"/> &#x201C;<sch:value-of select="text()"/>&#x201D; redirects to different URL.</sch:report>

    </sch:rule>

  </sch:pattern>

  <sch:properties>

    <sch:property id="fragment"><sch:value-of select="(ancestor-or-self::fragment|ancestor-or-self::xref-fragment|ancestor-or-self::properties-fragment)/@id
                                                       |ancestor-or-self::locator/@fragment"/></sch:property>

  </sch:properties>
</sch:schema>
