ALTER TABLE HOSTALIAS
    ADD UNIQUE KEY HostAliasName_key (Name);

ALTER TABLE CONTENT
    DROP Role,
    DROP Title,
    DROP Label;

ALTER TABLE URI
    DROP Status;

ALTER TABLE XLINK
    DROP ShowDefault,
    DROP ActuateDefault;

CREATE TABLE AUTHENTICATOR (
  AuthenticatorID INTEGER AUTO_INCREMENT PRIMARY KEY,
  MemberID        INTEGER        NOT NULL,
  PublicID        VARCHAR(16)    NOT NULL,
  Type            VARCHAR(20)    NOT NULL,
  Name            VARCHAR(50)    NULL,
  Confidential    VARBINARY(255) NULL,
  Parameters      VARCHAR(100)   NULL,
  CredentialId    VARBINARY(255) NULL,
  PublicKey       BLOB           NULL,
  Verified        TINYINT        NOT NULL,
  SignCount       INTEGER        NULL,
  Created         DATETIME(3)    NOT NULL,
  LastUsed        DATETIME(3)    NULL,
    UNIQUE KEY PublicID_key (PublicID),
    INDEX CredentialId_idx (CredentialId),
    FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
  ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

UPDATE DATABASE_METADATA SET Version='6.20';