ALTER TABLE DGROUP
  MODIFY CommentsModified DATETIME(3) NULL,
  MODIFY URIsModified DATETIME(3) NULL,
  MODIFY XRefsModified DATETIME(3) NULL;

ALTER TABLE MEMBER
  MODIFY BounceDate DATETIME(3) NULL,
  MODIFY Created DATETIME(3) NULL,
  MODIFY Activated DATETIME(3) NULL,
  MODIFY LastLogin DATETIME(3) NULL,
  MODIFY LastPasswordChange DATETIME(3) NULL;

ALTER TABLE XLINK
  MODIFY CreationDate DATETIME(3) NULL,
  MODIFY ModifiedDate DATETIME(3) NULL,
  MODIFY StatusChangedDate DATETIME(3) NULL,
  MODIFY AssignedDate DATETIME(3) NULL,
  MODIFY DueDate DATETIME(3) NULL;

ALTER TABLE URI
  MODIFY LastModified DATETIME(3) NULL,
  MODIFY DateCreated DATETIME(3) NULL,
  MODIFY DateArchived DATETIME(3) NULL;

ALTER TABLE MEMBER_FOR_DGROUP
  MODIFY Created DATETIME(3) NULL;

ALTER TABLE DGROUP_FOR_URI
  MODIFY Created DATETIME(3) NULL,
  MODIFY CommentsModified DATETIME(3) NULL,
  MODIFY Modified DATETIME(3) NULL;

ALTER TABLE DGROUPURI_FOR_DGROUP
  ADD GroupURIForGroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
  ADD EditURIs TINYINT NULL,
  ADD UNIQUE KEY GroupURIForGroup_key (GroupID,GroupURIID);

CREATE TABLE CLIENT(
  ClientID            INTEGER AUTO_INCREMENT PRIMARY KEY,
  Name                VARCHAR(255) NULL,
  Identifier          VARCHAR(16)  NULL,
  SecretHash          VARCHAR(64)  NULL,
  GrantType           VARCHAR(20)  NULL,
  RedirectURI         VARCHAR(255) NULL,
  ClientURI           VARCHAR(255) NULL,
  RequireConsent      TINYINT      NULL,
  Confidential        TINYINT      NULL,
  AccessTokenMaxAge   INTEGER      NULL,
  RefreshTokenMaxAge  INTEGER      NULL,
  Scopes              VARCHAR(255) NULL,
  MemberID            INTEGER      NULL,
  Description         VARCHAR(255) NULL,
    UNIQUE KEY Identifier_key (Identifier),
    UNIQUE KEY Name_key (Name),
    INDEX Name_idx (Name),
    INDEX Identifier_idx (Identifier),
    FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
  ) ENGINE = InnoDB, CHARACTER SET utf8;

CREATE TABLE PERSISTENT_TOKEN(
  TokenID     INTEGER AUTO_INCREMENT PRIMARY KEY,
  TokenHash   VARCHAR(50)   NULL,
  MemberID    INTEGER       NULL,
  ClientID    INTEGER       NULL,
  DateIssued  DATETIME(3)   NULL,
  DateExpires DATETIME (3)  NULL,
  Scopes      VARCHAR (255) NULL,
  Data        VARCHAR (255) NULL,
    INDEX TokenHash_idx (TokenHash),
    FOREIGN KEY (ClientID) REFERENCES CLIENT(ClientID),
    FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
) ENGINE = InnoDB, CHARACTER SET utf8;

UPDATE DATABASE_METADATA SET Version='5.90';
