/**
 * $Id: XDefCheckValueURIHandlerTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ValueURIHandler;
import  com.idaremedia.antx.valueuri.condition.XDefCheckValueURIHandler;

/**
 * Testsuite for {@linkplain XDefCheckValueURIHandler}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class XDefCheckValueURIHandlerTest extends ValueURIHandlerTestSkeleton
{
    /**
     * Initializes a new test case for named method.
     * @param methodname test case method's name (non-null)
     **/
    public XDefCheckValueURIHandlerTest(String methodname)
    {
        super("XDefCheckValueURIHandler::",methodname);
    }


    /**
     * Returns full test suite for XDefCheckValueURIHandler.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(XDefCheckValueURIHandlerTest.class);
    }

//  ---------------------------------------------------------------------------------------------------------
//  --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    protected ValueURIHandler newOUT()
    {
        return new XDefCheckValueURIHandler();
    }

//  ---------------------------------------------------------------------------------------------------------
//  ------------------------------------------- [ The Test Cases ] ------------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    /**
     * Verify a blank uri fragment is evaluated false.
     * @since JWare/AntX 0.5
     **/
    public void testBaseline_AntX05()
    {
        checkBaseline();
        
        ValueURIHandler out = newOUT();
        String tf = out.valueFrom("","$istype:",m_rqlink);
        assertEqual(tf,"false","$istype:");
        tf = out.valueFrom("","$istask:",m_rqlink);
        assertEqual(tf,"false","$istask:");
    }


    /**
     * Verify a builtin Ant type|task evaluates true.
     * @since JWare/AntX 0.5
     **/
    public void testIsTrueForBuiltinAntType_AntX05()
    {
        ValueURIHandler out = newOUT();
        String tf = out.valueFrom("property","$istask:property",m_rqlink);
        assertEqual(tf,"true","$istask:property");
        tf = out.valueFrom("fileset","$istype:fileset",m_rqlink);
        assertEqual(tf,"true","$istype:fileset");
    }


    /**
     * Verify an unknown type|task evaluates false.
     * @since JWare/AntX 0.5
     **/
    public void testIsFalseForUnregisteredType_AntX05()
    {
        ValueURIHandler out = newOUT();
        String tf = out.valueFrom("nosuchtype","$istype:nosuchtype",m_rqlink);
        assertEqual(tf,"false","$istype:nosuchtype");
    }
}

/* end-of-XDefCheckValueURIHandlerTest.java */